package com.openexchange.office.rest.tools;

import org.apache.http.impl.client.CloseableHttpClient;

import com.openexchange.net.ssl.SSLSocketFactoryProvider;
import com.openexchange.net.ssl.config.SSLConfigurationService;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;
import com.openexchange.rest.client.httpclient.HttpClients;
import com.openexchange.rest.client.httpclient.HttpClients.ClientConfig;

public class DataUrlHttpClient {
    private static volatile CloseableHttpClient httpClient;

    public static CloseableHttpClient getInstance() {
        CloseableHttpClient tmp = httpClient;
        if (tmp == null) {
            synchronized (DataUrlHttpClient.class) {
                tmp = httpClient;
                if (tmp == null) {
                    ClientConfig config = ClientConfig.newInstance();
                    config.setUserAgent("Open-Xchange Image Url Data Fetcher");
                    init(config);
                    tmp = HttpClients.getHttpClient(config, ServiceLookupRegistry.get().getService(SSLSocketFactoryProvider.class), ServiceLookupRegistry.get().getService(SSLConfigurationService.class));
                    httpClient = tmp;
                }
            }
        }
        return tmp;
    }

    private static void init(ClientConfig config) {
        config.setMaxTotalConnections(20);
        config.setMaxConnectionsPerRoute(10);
        config.setConnectionTimeout(30000);
        config.setSocketReadTimeout(30000);
    }
}
