/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rest;

import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.office.document.TemplateFilesScanner;
import com.openexchange.office.rest.tools.ParamValidator;
import com.openexchange.office.tools.error.ErrorCode;
import com.openexchange.office.tools.error.HttpStatusCode;
import com.openexchange.tools.session.ServerSession;

/**
 * {@link GetTemplateListAction}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 */
public class GetTemplateListAction extends DocumentRESTAction {
    @SuppressWarnings("deprecation")
	private static final Log LOG = com.openexchange.log.Log.loggerFor(GetTemplateListAction.class);

    private final static String[] MANDATORY_PARAMS = { ParameterDefinitions.PARAM_TYPE };

    private final TemplateFilesScanner m_templateFilesScanner;

    /**
     * Initializes a new {@link GetTemplateListAction}.
     * @param services
     */
    public GetTemplateListAction(final TemplateFilesScanner templateFilesScanner) {
        super();

        m_templateFilesScanner = templateFilesScanner;
    }

    /* (non-Javadoc)
     * @see com.openexchange.ajax.requesthandler.AJAXActionService#perform(com.openexchange.ajax.requesthandler.AJAXRequestData, com.openexchange.tools.session.ServerSession)
     */
    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        if (!ParamValidator.areAllParamsNonEmpty(requestData, MANDATORY_PARAMS))
            return ParamValidator.getResultFor(HttpStatusCode.BAD_REQUEST.getStatusCode());

        final JSONObject jsonObj = new JSONObject();
        final String type = requestData.getParameter(ParameterDefinitions.PARAM_TYPE).toLowerCase();
        final JSONArray templates = new JSONArray();
        AJAXRequestResult requestResult = null;

        if (null != session) {
        	ErrorCode errorCode = m_templateFilesScanner.searchForTemplates(session, type, templates);
        	try {
                jsonObj.put("error", errorCode.getAsJSON());
                jsonObj.put("templates", templates);
        	} catch (JSONException e) {
        		LOG.error("Exception while creating JSONObject answering AJAXRequest gettemplatelist", e);
        	}
        }

        requestResult = new AJAXRequestResult(jsonObj);

        return requestResult;
    }
}
