/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ot.presentation;

import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.api.OCValue;
import com.openexchange.office.ot.tools.ITransformHandler;
import com.openexchange.office.ot.tools.ITransformHandlerMap;
import com.openexchange.office.ot.tools.OpAlias;
import com.openexchange.office.ot.TransformHandlerBasic;
import com.openexchange.office.ot.tools.OpPair;
import com.openexchange.office.ot.tools.OTUtils;

public class TransformHandler implements ITransformHandlerMap {

    public static Map<OpPair, ITransformHandler> getTransformHandlerMap() {
        return opPairMap;
    }

    public static Set<OCValue> getSupportedOperations() {
        return supOpsSet;
    }

    static final public ImmutableSet<OCValue> supOpsSet = new ImmutableSet.Builder<OCValue>()
        .add(OCValue.INSERT_LAYOUT_SLIDE)
        .add(OCValue.INSERT_SLIDE)
        .add(OCValue.MOVE)
        .add(OCValue.MOVE_LAYOUT_SLIDE)
        .add(OCValue.MOVE_SLIDE)
        .build();

    static final public ImmutableMap<OpPair, ITransformHandler> opPairMap = new ImmutableMap.Builder<OpPair, ITransformHandler>()
        // INSERT_LAYOUT_SLIDE
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> handleInsertLayoutSlideInsertLayoutSlide(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> handleInsertLayoutSlideMoveLayoutSlide(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OpAlias.ALIAS_IGNORABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OpAlias.ALIAS_INSERT_CHAR), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OpAlias.ALIAS_INSERT_COMP), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OpAlias.ALIAS_MERGE_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.CHANGE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.DELETE), (localOp, externOp) -> handleInsertLayoutSlideDelete(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.DELETE_COLUMNS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.DELETE_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.DELETE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_CELLS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_COLUMN), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_DRAWING), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.INSERT_ROWS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.SET_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.SET_DOCUMENT_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.SPLIT_PARAGRAPH), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.SPLIT_TABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_LAYOUT_SLIDE, OCValue.UPDATE_FIELD), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_SLIDE
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.INSERT_SLIDE, OpAlias.ALIAS_IGNORABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OpAlias.ALIAS_INSERT_CHAR), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OpAlias.ALIAS_INSERT_COMP), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OCValue.INSERT_SLIDE, OpAlias.ALIAS_MERGE_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.CHANGE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.DELETE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.DELETE_COLUMNS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.DELETE_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.DELETE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_CELLS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_COLUMN), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_DRAWING), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.INSERT_ROWS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.SET_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.SET_DOCUMENT_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.SPLIT_PARAGRAPH), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.SPLIT_TABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_SLIDE, OCValue.UPDATE_FIELD), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // MOVE
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE, OpAlias.ALIAS_IGNORABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OpAlias.ALIAS_INSERT_CHAR), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OpAlias.ALIAS_INSERT_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OpAlias.ALIAS_MERGE_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE, OCValue.CHANGE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.DELETE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.DELETE_COLUMNS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.DELETE_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.DELETE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_CELLS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_COLUMN), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_DRAWING), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.INSERT_ROWS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.SET_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.SET_DOCUMENT_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.SPLIT_PARAGRAPH), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.SPLIT_TABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE, OCValue.UPDATE_FIELD), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // MOVE_LAYOUT_SLIDE
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> handleInsertLayoutSlideMoveLayoutSlide(localOp, externOp))
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OpAlias.ALIAS_IGNORABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OpAlias.ALIAS_INSERT_CHAR), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OpAlias.ALIAS_INSERT_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OpAlias.ALIAS_MERGE_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.CHANGE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.DELETE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.DELETE_COLUMNS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.DELETE_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.DELETE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_CELLS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_COLUMN), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_DRAWING), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.INSERT_ROWS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.SET_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.SET_DOCUMENT_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.SPLIT_PARAGRAPH), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.SPLIT_TABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_LAYOUT_SLIDE, OCValue.UPDATE_FIELD), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // MOVE_SLIDE
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE_SLIDE, OpAlias.ALIAS_IGNORABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OpAlias.ALIAS_INSERT_CHAR), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        .put(new OpPair(OCValue.MOVE_SLIDE, OpAlias.ALIAS_INSERT_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OpAlias.ALIAS_MERGE_COMP), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ---
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.CHANGE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.DELETE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.DELETE_COLUMNS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.DELETE_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.DELETE_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_CELLS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_COLUMN), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_COMMENT), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_DRAWING), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_STYLE_SHEET), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.INSERT_ROWS), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.SET_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.SET_DOCUMENT_ATTRIBUTES), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.SPLIT_PARAGRAPH), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.SPLIT_TABLE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.MOVE_SLIDE, OCValue.UPDATE_FIELD), (localOp, externOp) -> TransformHandlerBasic.handleNothing())

        //
        // basic operations vs presentation specific
        //
        // ALIAS_IGNORABLE
        .put(new OpPair(OpAlias.ALIAS_IGNORABLE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_IGNORABLE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_IGNORABLE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_IGNORABLE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_IGNORABLE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ALIAS_INSERT_CHAR
        .put(new OpPair(OpAlias.ALIAS_INSERT_CHAR, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_CHAR, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_CHAR, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_CHAR, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_CHAR, OCValue.MOVE_SLIDE), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        // ALIAS_INSERT_COMP
        .put(new OpPair(OpAlias.ALIAS_INSERT_COMP, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_COMP, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleInsertParaInsertPara(localOp, externOp))
        .put(new OpPair(OpAlias.ALIAS_INSERT_COMP, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_COMP, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_INSERT_COMP, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // ALIAS_MERGE_COMP
        .put(new OpPair(OpAlias.ALIAS_MERGE_COMP, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_MERGE_COMP, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_MERGE_COMP, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_MERGE_COMP, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OpAlias.ALIAS_MERGE_COMP, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // CHANGE_STYLE_SHEET
        .put(new OpPair(OCValue.CHANGE_STYLE_SHEET, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.CHANGE_STYLE_SHEET, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.CHANGE_STYLE_SHEET, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.CHANGE_STYLE_SHEET, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.CHANGE_STYLE_SHEET, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // DELETE
        .put(new OpPair(OCValue.DELETE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> handleInsertLayoutSlideDelete(localOp, externOp))
        .put(new OpPair(OCValue.DELETE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // DELETE COLUMNS
        .put(new OpPair(OCValue.DELETE_COLUMNS, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COLUMNS, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COLUMNS, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COLUMNS, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COLUMNS, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // DELETE_COMMENT
        .put(new OpPair(OCValue.DELETE_COMMENT, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COMMENT, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COMMENT, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COMMENT, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_COMMENT, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // DELETE_STYLE_SHEET
        .put(new OpPair(OCValue.DELETE_STYLE_SHEET, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_STYLE_SHEET, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_STYLE_SHEET, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_STYLE_SHEET, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.DELETE_STYLE_SHEET, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_CELLS
        .put(new OpPair(OCValue.INSERT_CELLS, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_CELLS, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_CELLS, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_CELLS, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_CELLS, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_COLUMN
        .put(new OpPair(OCValue.INSERT_COLUMN, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COLUMN, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COLUMN, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COLUMN, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COLUMN, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_COMMENT
        .put(new OpPair(OCValue.INSERT_COMMENT, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COMMENT, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COMMENT, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COMMENT, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_COMMENT, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_DRAWING
        .put(new OpPair(OCValue.INSERT_DRAWING, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_DRAWING, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_DRAWING, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_DRAWING, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_DRAWING, OCValue.MOVE_SLIDE), (localOp, externOp) -> handleMoveSlideInsertChar(localOp, externOp))
        // INSERT_ROWS
        .put(new OpPair(OCValue.INSERT_ROWS, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_ROWS, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_ROWS, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_ROWS, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_ROWS, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // INSERT_STYLE_SHEET
        .put(new OpPair(OCValue.INSERT_STYLE_SHEET, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_STYLE_SHEET, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_STYLE_SHEET, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_STYLE_SHEET, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.INSERT_STYLE_SHEET, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // SET_ATTRIBUTES
        .put(new OpPair(OCValue.SET_ATTRIBUTES, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_ATTRIBUTES, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_ATTRIBUTES, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_ATTRIBUTES, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_ATTRIBUTES, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // SET_DOCUMENT_ATTRIBUTES
        .put(new OpPair(OCValue.SET_DOCUMENT_ATTRIBUTES, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_DOCUMENT_ATTRIBUTES, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_DOCUMENT_ATTRIBUTES, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_DOCUMENT_ATTRIBUTES, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SET_DOCUMENT_ATTRIBUTES, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // SPLIT_PARAGRAPUH
        .put(new OpPair(OCValue.SPLIT_PARAGRAPH, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_PARAGRAPH, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_PARAGRAPH, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_PARAGRAPH, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_PARAGRAPH, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // SPLIT_TABLE
        .put(new OpPair(OCValue.SPLIT_TABLE, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_TABLE, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_TABLE, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_TABLE, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.SPLIT_TABLE, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        // UPDATE_FIELD
        .put(new OpPair(OCValue.UPDATE_FIELD, OCValue.INSERT_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.UPDATE_FIELD, OCValue.INSERT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.UPDATE_FIELD, OCValue.MOVE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.UPDATE_FIELD, OCValue.MOVE_LAYOUT_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .put(new OpPair(OCValue.UPDATE_FIELD, OCValue.MOVE_SLIDE), (localOp, externOp) -> TransformHandlerBasic.handleNothing())
        .build();

    /**
     * Handling a moveSlide operation and an insertChar operation.
     *
     * Example:
     * { name: moveSlide, start: [1], end: [3] }
     * @throws JSONException
     */
    private static JSONObject handleMoveSlideInsertChar(JSONObject localOp, JSONObject extOp) throws JSONException {

        final JSONObject moveOp = OTUtils.getOperation(OCValue.MOVE_SLIDE, localOp, extOp);
        final JSONObject insertOp = moveOp==localOp ? extOp : localOp;

        // the slide start position of the move operation
        final int movePosStart = OTUtils.getStartPosition(moveOp).getInt(0);
        // the slide end position of the move operation
        final int movePosTo = OTUtils.optEndPosition(moveOp).getInt(0);
        // the slide position of the insert operation
        final JSONArray insertPosStartArray = OTUtils.getStartPosition(insertOp);
        final int insertPosStart = insertPosStartArray.getInt(0);

        if (movePosStart == insertPosStart) {
            insertPosStartArray.put(0, movePosTo); // the drawing with the inserted text was moved
        } else if (movePosStart > insertPosStart && movePosTo <= insertPosStart) {
            insertPosStartArray.put(0, insertPosStart + 1);
        } else if (movePosStart < insertPosStart && movePosTo > insertPosStart) {
            insertPosStartArray.put(0, insertPosStart - 1);
        }
        return null;
    };

    private static JSONObject handleInsertLayoutSlideInsertLayoutSlide(JSONObject localOp, JSONObject extOp) throws JSONException {

        // Both operations influence its position, if they have the same master slide.
        if (!localOp.getString(OCKey.TARGET.value()).equals(extOp.getString(OCKey.TARGET.value()))) {
            return null;
        }
        // reading the integer start positions
        int localStart = localOp.optInt(OCKey.START.value(), 0);
        int extStart = extOp.optInt(OCKey.START.value(), 0);

        if (localStart < extStart) {
            extOp.put(OCKey.START.value(), Integer.valueOf(extStart + 1));
        } else {
            localOp.put(OCKey.START.value(), Integer.valueOf(localStart + 1));
        }
        return null;
    }

    private static JSONObject handleInsertLayoutSlideDelete(JSONObject localOp, JSONObject extOp) throws JSONException {
        // TODO
        return null;
    }

    private static JSONObject handleInsertLayoutSlideMoveLayoutSlide(JSONObject localOp, JSONObject extOp) throws JSONException {
        // TODO
        return null;
    }
}
