/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.imagemgr.osgi;

import java.util.List;

import org.slf4j.Logger;

import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.office.imagemgr.IResourceManagerFactory;
import com.openexchange.office.imagemgr.impl.ResourceLocker;
import com.openexchange.office.imagemgr.impl.ResourceManagerFactory;
import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.office.tools.osgi.ActivatorBase;

public class ImageManagerActivator extends ActivatorBase {

    //-------------------------------------------------------------------------
    private static final String SERVICE_NAME = "com.openexchange.office.imagemgr";
    
    //-------------------------------------------------------------------------
    private static final Logger LOG = LogFactory.getSlfLog(ImageManagerActivator.class);


    //-------------------------------------------------------------------------
	public ImageManagerActivator() throws Exception {
		super(SERVICE_NAME);
	}

    //-------------------------------------------------------------------------
	@Override
	protected void listMandatoryServiceImports(List<Class<?>> lServices) throws Exception {
        lServices.add (ManagedFileManagement    .class);
        lServices.add (DistributedFileManagement.class);
	}

    //-------------------------------------------------------------------------
	@Override
	protected void listOptionalServiceImports(List<Class<?>> lServices) throws Exception {
		// no optional services needed
	}

    //-------------------------------------------------------------------------
	@Override
	protected void activate() throws Exception {
		LOG.info("activate {} ...", SERVICE_NAME);
		try {
			final ResourceManagerFactory aResMgrFactory = new ResourceManagerFactory();
			final IResourceManagerFactory resourceService = aResMgrFactory;
			m_aResMgrFactory = aResMgrFactory;
			registerService(IResourceManagerFactory.class, resourceService);

			final ResourceLocker aResLocker = new ResourceLocker();
			m_aResourceLocker = aResLocker;
			registerService(ResourceLocker.class, aResLocker);
		} catch (Throwable t) {
			LOG.error("activate {} failed", SERVICE_NAME, t);
			throw t;
		}
	}

    //-------------------------------------------------------------------------
	@Override
	protected void deactivate() throws Exception {
		LOG.info("deactivate {} ...", SERVICE_NAME);

		final ResourceLocker aResLocker = m_aResourceLocker;
		if (null != aResLocker) {
			aResLocker.shutdown();
		}

		final ResourceManagerFactory aResMgrFactory = m_aResMgrFactory;
		if (null != aResMgrFactory) {
			aResMgrFactory.shutdown();
		}
	}

    //-------------------------------------------------------------------------
	private ResourceManagerFactory m_aResMgrFactory;

    //-------------------------------------------------------------------------
	private ResourceLocker         m_aResourceLocker;
}
