package com.openexchange.office.htmldoc;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentNode
        extends NodeHolder
{
    private final static Logger LOG                = LoggerFactory.getLogger(DocumentNode.class);
    private final static String IMPLICIT_PARAGRAPH = Paragraph.PARASTART + "jquerydata=\"{&quot;implicit&quot;:true}\" >" + Paragraph.EMPTYSPAN + "</div>";

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        List<INode> children = getChildren();
        final int count = getChildrenCount();
        boolean mustSetSplitpoint = false;

        int paraCount = 0;
        int textLength = 0;
        int i = 0;
        for (; i < count; i++)
        {
            INode child = children.get(i);
            textLength += child.getTextLength();

            // Bug 35671
            // Formatting of tables is done asynchronously, therefore we
            // don't want to have a splitpoint at all, if we find a table.
            if (child instanceof Table) {
                break;
            }

            paraCount += determineParagraphCount(child);
            if ((textLength > 2000) && (paraCount > 25))
                mustSetSplitpoint = true;

            if (mustSetSplitpoint && (child instanceof ISplitpoint))
            {
                ((ISplitpoint) child).setSplitpoint(true);
                LOG.debug("set splitpoint on " + i + " of " + count + " elements");
                break;
            }

            child.appendContent(document);
        }

        for (; i < count; i++)
        {
            INode child = children.get(i);
            child.appendContent(document);
        }

        if (count == 0 || getChildren().get(count - 1) instanceof Table)
        {
            // implicit Paragraph
            document.append(IMPLICIT_PARAGRAPH);
        }

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    private int determineParagraphCount(
        final INode node)
    {
        int result = 0;

        if (node instanceof Paragraph)
            return 1;
        else if (node instanceof Table)
        {
            final Table table = (Table) node;
            return table.getRowCount();
        }

        return result;
    }
}
