/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.drawingml;

import org.docx4j.dml.IShape;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.ooxml.OfficeOpenXMLOperationDocument;

public class Shape {

    public static void applyAttrsFromJSON(OfficeOpenXMLOperationDocument operationDocument, JSONObject attrs, IShape shape, boolean rootShape)
    	    throws JSONException, InvalidFormatException, PartUnrecognisedException {

    	DMLHelper.applyTextBodyPropertiesFromJson(shape.getTextBodyProperties(true), attrs);
        DMLHelper.applyNonVisualDrawingProperties(shape, attrs.optJSONObject(OCKey.DRAWING.value()));
        DMLHelper.applyNonVisualDrawingShapeProperties(shape, attrs.optJSONObject(OCKey.DRAWING.value()));
	    shape.setSpPr(DMLHelper.applyShapePropertiesFromJson(shape.getSpPr(), attrs, operationDocument, operationDocument.getContextPart(), rootShape));
	    final JSONObject characterAttrs = attrs.optJSONObject(OCKey.CHARACTER.value());
	    if(characterAttrs!=null) {
	    	final JSONObject color = characterAttrs.optJSONObject(OCKey.COLOR.value());
	    	if(color!=null) {
    			DMLHelper.createSolidColorFillPropertiesFromJson(shape.getStyle(true).getFontRef(), color);
	    	}
	    }
    }

    public static void createJSONAttrs(OfficeOpenXMLOperationDocument operationDocument, JSONObject attrs, IShape shape, boolean rootShape)
    	throws JSONException, FilterException {

    	DMLHelper.createJsonFromTextBodyProperties(attrs, shape.getTextBodyProperties(false));
    	DMLHelper.createJsonFromNonVisualDrawingProperties(attrs, shape);
    	DMLHelper.createJsonFromNonVisualDrawingShapeProperties(attrs, shape);
        DMLHelper.createJsonFromShapeProperties(attrs, shape.getSpPr(), operationDocument.getThemePart(true), shape.getStyle(false), operationDocument.getContextPart(), true, rootShape);
    }
}
