/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.components;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.IContentAccessor;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.SplitMode;
import com.openexchange.office.filter.core.component.Child;
import com.openexchange.office.filter.core.component.Component;
import com.openexchange.office.filter.core.component.ComponentContext;
import com.openexchange.office.filter.core.component.IComponent;
import com.openexchange.office.filter.ooxml.OfficeOpenXMLOperationDocument;

public abstract class OfficeOpenXMLComponent extends Component<OfficeOpenXMLOperationDocument> implements IComponent<OfficeOpenXMLOperationDocument> {

    private static HashSet<Class<?>> rootElements = new HashSet<Class<?>>();

    /*
     * simply returns o, but in case o is a JAXBElement and a RootElement annotation is available
     * then the parent content list is updated and the contentModel is returned.
     * */
    public static Object getContentModel(DLNode<Object> node, Object parent) {

        if (node.getData() instanceof javax.xml.bind.JAXBElement) {
            boolean hasRootElement = rootElements.contains(((javax.xml.bind.JAXBElement<?>)node.getData()).getDeclaredType());
            if(!hasRootElement) {
                final Annotation[] annotations = ((javax.xml.bind.JAXBElement<?>)node.getData()).getDeclaredType().getAnnotations();
                for(Annotation annotation : annotations) {
                    if(annotation instanceof XmlRootElement) {
                        rootElements.add(((javax.xml.bind.JAXBElement<?>)node.getData()).getDeclaredType());
                        hasRootElement = true;
                        break;
                    }
                }
            }
            if(hasRootElement) {
                node.setData(((JAXBElement<?>)node.getData()).getValue());
            }
        }
        if(node.getData() instanceof Child) {
        	((Child)node.getData()).setParent(parent);
        }
        return node.getData();
    }

    public OfficeOpenXMLComponent(OfficeOpenXMLOperationDocument operationDocument, DLNode<Object> _node, int _componentNumber) {
        super(operationDocument, _node, _componentNumber);
    }

    public OfficeOpenXMLComponent(ComponentContext<OfficeOpenXMLOperationDocument> parentContext, DLNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

    public abstract JSONObject createJSONAttrs(JSONObject attrs) throws Exception;

    public static void move(OfficeOpenXMLOperationDocument operationDocument, JSONArray startPosition, JSONArray endPosition, JSONArray toPosition)
        throws JSONException {

    	if(endPosition==null) {
    		endPosition = startPosition;
    	}
    	else if(startPosition.length()!=endPosition.length())
            throw new JSONException("ooxml export: move operation, size of startPosition != size of endPosition");

        final Component<OfficeOpenXMLOperationDocument> sourceBegComponent = operationDocument.getRootComponent().getComponent(startPosition, startPosition.length());
        final Component<OfficeOpenXMLOperationDocument> sourceEndComponent = sourceBegComponent.getComponent(endPosition.getInt(startPosition.length()-1));
        final DLList<Object> sourceContent = (DLList<Object>)((IContentAccessor)sourceBegComponent.getParentComponent().getNode().getData()).getContent();
        sourceBegComponent.splitStart(startPosition.getInt(startPosition.length()-1), SplitMode.DELETE);
        sourceEndComponent.splitEnd(endPosition.getInt(startPosition.length()-1), SplitMode.DELETE);

        // destComponent is empty if the content is to be appended
        final Component<OfficeOpenXMLOperationDocument> destComponent = operationDocument.getRootComponent().getComponent(toPosition, toPosition.length());
        Component<OfficeOpenXMLOperationDocument> destParentComponent;
        if(destComponent!=null) {
        	destComponent.splitStart(toPosition.getInt(toPosition.length()-1), SplitMode.DELETE);
        	destParentComponent = destComponent.getParentComponent();
        }
        else {
        	destParentComponent = operationDocument.getRootComponent().getComponent(toPosition, toPosition.length()-1);
        }
        final DLList<Object> destContent = (DLList<Object>)((IContentAccessor)destParentComponent.getNode().getData()).getContent();
        final boolean before = sourceContent==destContent && startPosition.getInt(startPosition.length()-1) <= toPosition.getInt(toPosition.length()-1) ? false : true;
        if(destComponent!=null) {
            sourceContent.moveNodes(sourceBegComponent.getContextChild(null).getNode(), sourceEndComponent.getContextChild(null).getNode(), destContent,
                destComponent.getContextChild(null).getNode(), before, destParentComponent.getNode().getData());
        }
        else {
            sourceContent.moveNodes(sourceBegComponent.getContextChild(null).getNode(), sourceEndComponent.getContextChild(null).getNode(), destContent,
                destContent.getLastNode(), false, destParentComponent.getNode().getData());
        }
    }

    @Override
    public String simpleName() {
        // TODO Auto-generated method stub
        return "";
    }
}
