/*
 *
*    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odt.dom;

import java.util.HashMap;
import java.util.Random;
import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.styles.StyleManager;

public class TextList implements Cloneable {

	private TextListItem parentTextListItem;
	private int listLevel;

	// value or null
	private String id;
	private String styleName;
	private String continueList;
	private Boolean continueNumbering;

	final private StyleManager styleManager;

	public TextList(StyleManager styleManager, TextListItem parentTextListItem) {
        this.styleManager = styleManager;
	    init(parentTextListItem);
	}

	public TextList(StyleManager styleManager, TextListItem parentTextListItem, Attributes attributes) {
	    this.styleManager = styleManager;
	    init(parentTextListItem);

	    id = attributes.getValue("xml:id");
        styleName = attributes.getValue("text:style-name");
        continueList = attributes.getValue("text:continue-list");
        final String contNumbering = attributes.getValue("text:continue-numbering");
        if(contNumbering!=null) {
            continueNumbering = Boolean.parseBoolean(contNumbering);
        }
	}

	private void init(TextListItem parent) {
        this.parentTextListItem = parent;
        if(parentTextListItem==null) {
            applyUniqueId();
            listLevel = 0;
        }
        else {
            setId(null);
            listLevel = parentTextListItem.getParentTextList().getListLevel() + 1;
        }
	}

	public void writeAttributes(SerializationHandler output)
		throws SAXException {

	    final HashMap<String, String> usedTextListStyles = styleManager.getListItemStyleIds();
	    final String lastUsedId = usedTextListStyles.get(styleName);

	    SaxContextHandler.addAttribute(output, Namespaces.XML, "id", "xml:id", id);
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "style-name", "text:style-name", styleName);
        if(lastUsedId!=null&&!lastUsedId.isEmpty()) {
            SaxContextHandler.addAttribute(output, Namespaces.TEXT, "continue-list", "text:continue-list", lastUsedId);
        }
		if(continueNumbering!=null) {
		    SaxContextHandler.addAttribute(output, Namespaces.TEXT, "continue-numbering", "text:continue-numbering", continueNumbering.toString());
		}
		usedTextListStyles.put(styleName, id);
	}

	public TextListItem getParentTextListItem() {
		return parentTextListItem;
	}

    public TextList getTextListRoot() {
        TextList textListRoot = this;
        while(textListRoot.getParentTextListItem()!=null&&textListRoot.getParentTextListItem().getParentTextList()!=null) {
            textListRoot = textListRoot.getParentTextListItem().getParentTextList();
        }
        return textListRoot;
    }

    public int getListLevel() {
		return listLevel;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
	    this.id = id;
	}

	private void applyUniqueId() {
        this.setId("list" + Integer.toString((new Random().nextInt()), 0));
	}

	public String getStyleName(boolean deepSearch) {
	    if(!deepSearch) {
	        return styleName;
	    }
	    TextList textList = this;
	    while(true) {
	        if(textList.styleName!=null&&!textList.styleName.isEmpty()) {
	            return textList.styleName;
	        }
	        if(textList.getParentTextListItem()==null) {
	            return null;
	        }
	        textList = textList.getParentTextListItem().getParentTextList();
	    }
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	public String getContinueList() {
		return continueList;
	}

	public void setContinueList(String continueList) {
	    this.continueList = continueList;
	}

	public Boolean getContinueNumbering() {
		return continueNumbering;
	}

	public void setContinueNumbering(Boolean continueNumbering) {
	    this.continueNumbering = continueNumbering;
	}

    @Override
    public TextList clone() {
        try {
            final TextList clone = (TextList)super.clone();
            if(clone.id!=null) {
                applyUniqueId();
            }
            if(parentTextListItem!=null) {
                parentTextListItem = parentTextListItem.clone();
            }
            return clone;
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}
