/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom.chart;

import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.core.chart.ChartSeries;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.DOMBuilder;
import com.openexchange.office.filter.odf.ElementNS;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class ChartSeriesHandler extends DOMBuilder {

    private final ChartContentHandler parentContext;
    private final ElementNS seriesEl;

    public ChartSeriesHandler(ChartContentHandler parentContext, ElementNS seriesEl) {
        super(seriesEl, parentContext);
        this.parentContext = parentContext;
        this.seriesEl = seriesEl;
    }

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
        OdfOperationDoc.abortOnLowMemory(getFileDom());

        AttributesImpl attrs = new AttributesImpl(attributes);

        ChartSeries series = (ChartSeries) seriesEl.getUserData(ChartContent.USERDATA);

        switch (qName) {
            case "chart:data-point":

                Integer repeated = attrs.getIntValue("chart:repeated");
                if (repeated == null) {
                    repeated = 1;
                }

                String styleName = attrs.getValue(ChartContent.ODF_STYLE);

                JSONObject dataPointStyle = null;
                if (StringUtils.isNotEmpty(styleName)) {
                    dataPointStyle = parentContext.getChart().getStyleAttrs(styleName);
                    if (dataPointStyle.isEmpty()) {
                        dataPointStyle = null;
                    } else {
                        dataPointStyle.putSafe(OCKey.MARKER_FILL.value(), dataPointStyle.optJSONObject(OCKey.FILL.value()));
                        dataPointStyle.putSafe(OCKey.MARKER_BORDER.value(), dataPointStyle.optJSONObject(OCKey.FILL.value()));
                    }
                }
                if (dataPointStyle == null || dataPointStyle.isEmpty()) {
                    dataPointStyle = new JSONObject();
                }
                try {
                    String position = null;

                    if (dataPointStyle.has(OCKey.SERIES.value())){
                        JSONObject seriesJSON = dataPointStyle.getJSONObject(OCKey.SERIES.value());
                        if (seriesJSON.has(OCKey.DATA_LABEL.value())) {
                            JSONObject dataLabel = seriesJSON.getJSONObject(OCKey.DATA_LABEL.value());
                            if (dataLabel.has(OCKey.DATA_LABEL_POS.value())) {
                                position = dataLabel.getString(OCKey.DATA_LABEL_POS.value());
                            }
                            dataPointStyle.remove(OCKey.DATA_LABELS.value());
                        }
                        dataPointStyle.remove(OCKey.SERIES.value());
                    
                    }
                    series.addLabelPointPosition(position);

                } catch (JSONException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                for (int i = 0; i < repeated; i++) {
                    series.addDataPointStyle(dataPointStyle);
                }

                seriesEl.appendChild(new ElementNS(getFileDom(), attributes, uri, qName));

                return this;

            case "chart:domain":
                String values = ChartContent.getFormula(attrs.getValue(ChartContent.ODF_TABLE_CELL_RANGE));

                if (series.isScatter() || series.getSeriesJSON().has(OCKey.BUBBLES.value())) {
                    series.setNames(values);
                } else {
                    series.setBubbles(values);
                }
                seriesEl.appendChild(new ElementNS(getFileDom(), attributes, uri, qName));

                return this;
                
            case "chart:error-indicator":
                
                return super.startElement(attributes, uri, localName, qName);
            default:
                return this;
        }
    }

}
