/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * 
 * @author sven.jacobiATopen-xchange.com
 * 
 */

package com.openexchange.office.filter.ods.dom;

import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.lang.mutable.MutableInt;

@SuppressWarnings("serial")
final public class ColumnStyle extends HashMap<String, MutableInt> implements Comparable<ColumnStyle>{

	private int min;
	private int max;

	private boolean init = false;
	private String maxUsedStyle = null;

	public ColumnStyle(int min) {
		this.min = min;
		this.max = min;
	}

	public ColumnStyle(int min, int max) {
		this.min = min;
		this.max = max;
	}

	public ColumnStyle(ColumnStyle c, int min, int max) {
		this.min = min;
		this.max = max;

		// cloning HashMap
		final Iterator<java.util.Map.Entry<String, MutableInt>> iter = c.entrySet().iterator();
		while(iter.hasNext()) {
			final java.util.Map.Entry<String, MutableInt> entry = iter.next();
			put(entry.getKey(), new MutableInt(entry.getValue().intValue()));
		}
	}

	public void addStyleUsage(String style, int count) {
		final MutableInt val = get(style);
		if(val!=null) {
			val.add(count);
		}
		else {
			put(style, new MutableInt(count));
		}
	}

	public String getMaxUsedStyle() {
		if(!init) {
			int max = 0;
			final Iterator<java.util.Map.Entry<String, MutableInt>> iter = entrySet().iterator();
			while(iter.hasNext()) {
				final java.util.Map.Entry<String, MutableInt> entry = iter.next();
				if(entry.getValue().intValue()>max) {
					max = entry.getValue().intValue();
					maxUsedStyle = entry.getKey();
				}
			}
			init = true;
			clear();
		}
		return maxUsedStyle;
	}

	public int getMin() {
		return min;
	}

	public int getMax() {
		return max;
	}

	public void setMax(int max) {
		this.max = max;
	}

	@Override
	public int compareTo(ColumnStyle arg0) {
		return min - arg0.getMin();
	}
}
