/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odp.dom;

import java.util.HashMap;
import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Decl;
import com.openexchange.office.filter.odf.DeclHandler;
import com.openexchange.office.filter.odf.ElementNSWriter;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.UnknownContentHandler;

public class PresentationHandler extends SaxContextHandler {

	final Presentation presentation;

    public PresentationHandler(SaxContextHandler parentContext, Presentation presentation) {
    	super(parentContext);

    	this.presentation = presentation;
    }

    @Override
    public SaxContextHandler startElement(Attributes _attributes, String uri, String localName, String qName) {
        final AttributesImpl attributes = new AttributesImpl(_attributes);
    	if(qName.equals("draw:page")) {
    	    final Page page = new DrawingPage(attributes);
    	    presentation.getContent().add(page);
    	    return new PageHandler(this, page);
    	}

    	final String declName = attributes.getValue("presentation:name");
    	if(declName!=null&&!declName.isEmpty()) {
    	    HashMap<String, Decl> decls = null;
    	    if(qName.equals("presentation:date-time-decl")) {
    	        decls = presentation.getDateTimeDecls(true);
        	}
        	else if (qName.equals("presentation:footer-decl")) {
        	    decls = presentation.getFooterDecls(true);
        	}
        	else if (qName.equals("presentation:header-decl")) {
        	    decls = presentation.getHeaderDecls(true);
        	}
    	    if(decls!=null) {
    	        final Decl decl = new Decl(qName, localName, uri, attributes);
    	        decls.put(declName, decl);
    	        return new DeclHandler(this, decl);
    	    }
    	}
        final ElementNSWriter element = new ElementNSWriter(getFileDom(), _attributes, uri, qName);
        presentation.getContent().add(element);
        return new UnknownContentHandler(this, element);
    }

	@Override
	public void endElement(String localName, String qName) {
		super.endElement(localName, qName);
	}

	@Override
	public void endContext(String qName, String characters) {
		super.endContext(qName, characters);
	}
}
