/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.listlevel;

import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.properties.TextProperties;
import com.openexchange.office.filter.odf.styles.StyleManager;
import com.openexchange.office.filter.odf.styles.TextListStyle;

public class ListLevelStyleBullet extends ListLevelStyleEntry {

	public ListLevelStyleBullet(AttributesImpl attributesImpl) {
		super(attributesImpl);
	}

	/*
	 * level starting from 1 to ...
	 */
	public ListLevelStyleBullet(int level) {
	    super(new AttributesImpl());
	    setListLevel(level);
	}

	@Override
	public ListLevelStyleBullet clone() {
		return (ListLevelStyleBullet)super._clone();
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		//
	}

    @Override
    public void createPresentationAttrs(StyleManager styleManager, String listStyleType, boolean contentAutoStyle, OpAttrs paragraphAttrs) {
        final OpAttrs bullet = paragraphAttrs.getMap(OCKey.BULLET.value(), true);
        bullet.put(OCKey.TYPE.value(), "character");
        final String c = getAttribute("text:bullet-char");
        if(c!=null) {
            bullet.put(OCKey.CHARACTER.value(), c);
            attributes.setValue(Namespaces.TEXT, "bullet-char", "text:bullet-char", c);
        }
        final TextProperties textProperties = getTextProperties(false);
        if(textProperties!=null) {
	        final String buSize = textProperties.getAttribute("fo:font-size");
	        if(buSize!=null) {
	        	final Integer o = AttributesImpl.getPercentage(buSize, null);
	        	if(o!=null) {
		            final OpAttrs bulletSize = paragraphAttrs.getMap(OCKey.BULLET_SIZE.value(), true);
		            bulletSize.put(OCKey.TYPE.value(), "percent");
		            bulletSize.put(OCKey.SIZE.value(), o);
	        	}
	        }
        }
        super.createPresentationAttrs(styleManager, listStyleType, contentAutoStyle, paragraphAttrs);
    }

    @Override
    public void applyPresentationAttrs(StyleManager styleManager, JSONObject paragraphAttrs)
        throws JSONException {

    	final TextProperties textProperties = getTextProperties(true);
        final Object bulletAttrs = paragraphAttrs.opt(OCKey.BULLET.value());
        if(bulletAttrs instanceof JSONObject) {
            final Object character = ((JSONObject)bulletAttrs).opt(OCKey.CHARACTER.value());
            if(character!=null) {
                String c = "";
                if(character instanceof String) {
                    if(!((String)character).isEmpty()) {
                        c = ((String) character).substring(0, 1);
                    }
                }
                else {
                    c = "*";
                }
                attributes.setValue(Namespaces.TEXT, "bullet-char", "text:bullet-char", c);
            }
        }
        final Object bulletSizeAttrs = paragraphAttrs.opt(OCKey.BULLET_SIZE.value());
        if(bulletSizeAttrs!=null) {
        	if(bulletSizeAttrs instanceof JSONObject) {
        		final String type = ((JSONObject)bulletSizeAttrs).optString(OCKey.TYPE.value());
        		if("percent".equals(type)) {
        			final Object buSize = ((JSONObject)bulletSizeAttrs).opt(OCKey.SIZE.value());
        			if(buSize!=null) {
        				if(buSize instanceof Number) {
        					textProperties.getAttributes().setValue(Namespaces.FO, "font-size", "fo:font-size", Integer.toString(((Number)buSize).intValue())+"%");
        				}
        				else {
        					textProperties.getAttributes().remove("fo:font-size");
        				}
        			}
        		}
        	}
        	else {
    			attributes.remove("fo:font-size");
    			// TODO what is "text:bullet-relative-size");
        	}
        }
        super.applyPresentationAttrs(styleManager, paragraphAttrs);
    }

    @Override
	public void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {
	    final Integer listLevel = getListLevel(0);
		if(listLevel>=1&&listLevel<=10) {
			TextListStyle.createListLevelDefinition(this, attrs, listLevel);
		}
	}

	@Override
	public String getQName() {
		return "text:list-level-style-bullet";
	}

	@Override
	public String getLocalName() {
		return "list-level-style-bullet";
	}

	@Override
	public String getNamespace() {
		return Namespaces.TEXT;
	}
}
