/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package org.xlsx4j.sml_2018;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.xlsx4j.sml.CTExtensionList;
import com.openexchange.office.filter.core.spreadsheet.ICellRefAccess;
import com.openexchange.office.filter.core.spreadsheet.SmlUtils;
import com.openexchange.office.filter.core.spreadsheet.SmlUtils.CellRef;

/**
 * 
 * This complex type specifies the properties of a threaded comment.
 * 
 * <xsd:complexType name="CT_ThreadedComment">
 *  <xsd:sequence>
 *    <xsd:element name="text" type="x:ST_Xstring" minOccurs="0" maxOccurs="1"/>
 *    <xsd:element name="mentions" type="CT_ThreadedCommentMentions" minOccurs="0" maxOccurs="1"/>
 *    <xsd:element name="extLst" type="x:CT_ExtensionList" minOccurs="0" maxOccurs="1"/>
 *  </xsd:sequence>
 *  <xsd:attribute name="ref" type="x:ST_Ref" use="optional"/> // optional is wrong. Excel crashes if the ref is missed
 *  <xsd:attribute name="dT" type="xsd:dateTime" use="optional"/>
 *  <xsd:attribute name="personId" type="x:ST_Guid" use="required"/>
 *  <xsd:attribute name="id" type="x:ST_Guid" use="required"/>
 *  <xsd:attribute name="parentId" type="x:ST_Guid" use="optional"/>
 *  <xsd:attribute name="done" type="xsd:boolean" use="optional"/>
 * </xsd:complexType>
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_ThreadedComment", propOrder = {})
@XmlRootElement(name="threadedComment")
public class CTThreadedComment implements ICellRefAccess {

    @XmlElement
    protected String text;
    
    @XmlElement
    protected CTThreadedCommentMentions mentions;
    
    @XmlElement
    protected CTExtensionList extLst;

    // dt attribute that specifies the UTC time that the comment was authored for the first time.
    @XmlAttribute(name = "dT")
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar dateTime;
    
    // personId: : An ST_Guid attribute that specifies a unique identifier for the person mentioned. This attribute MUST correspond to the id specified in CT_Person
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String personId;
    
    @XmlAttribute(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String id;
    
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String parentId;
    
    @XmlAttribute
    @XmlSchemaType(name = "boolean")
    protected Boolean done;
    
    @XmlTransient
    protected CellRef cellRef;
    @XmlAttribute(name = "ref", required = true)
    protected String getRef() {
        if(cellRef==null) {
            return "";
        }
        return SmlUtils.getCellRef(cellRef);
    }
    
    /**
     * Sets the value of the ref property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    protected void setRef(String value) {
        cellRef = SmlUtils.createCellRef(value);
    }

    @Override
    public CellRef getCellRef(boolean forceCreate) {
        if(cellRef==null&&forceCreate) {
            cellRef = new CellRef(0, 0);
        }
        return cellRef;
    }

    @Override
    public void setCellRef(CellRef cellRef) {
        this.cellRef = cellRef;
    }
    
    public CTExtensionList getExtLst() {
        return extLst;
    }
    
    public void setExtLst(CTExtensionList extLst) {
        this.extLst = extLst;
    }
    
    public String getText() {
        return text;
    }
    
    public void setText(String text) {
        this.text = text;
    }

    
    public XMLGregorianCalendar getDateTime() {
        return dateTime;
    }

    
    public void setDateTime(XMLGregorianCalendar dateTime) {
        this.dateTime = dateTime;
    }

    
    public String getPersonId() {
        return personId;
    }

    
    public void setPersonId(String personId) {
        this.personId = personId;
    }

    
    public String getId() {
        return id;
    }

    
    public void setId(String id) {
        this.id = id;
    }

    
    public String getParentId() {
        return parentId;
    }

    
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    
    public Boolean getDone() {
        return done;
    }

    
    public void setDone(Boolean done) {
        this.done = done;
    }

    
    public CTThreadedCommentMentions getMentions() {
        return mentions;
    }

    
    public void setMenitions(CTThreadedCommentMentions mentions) {
        this.mentions = mentions;
    }
}
