/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.xlsx4j.schemas.microsoft.com.office.spreadsheetml_2010_11.main;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ST_TimelineStyleType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ST_TimelineStyleType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="selectionLabel"/>
 *     &lt;enumeration value="timeLevel"/>
 *     &lt;enumeration value="periodLabel1"/>
 *     &lt;enumeration value="periodLabel2"/>
 *     &lt;enumeration value="selectedTimeBlock"/>
 *     &lt;enumeration value="unselectedTimeBlock"/>
 *     &lt;enumeration value="selectedTimeBlockSpace"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ST_TimelineStyleType")
@XmlEnum
public enum STTimelineStyleType {

    @XmlEnumValue("selectionLabel")
    SELECTION_LABEL("selectionLabel"),
    @XmlEnumValue("timeLevel")
    TIME_LEVEL("timeLevel"),
    @XmlEnumValue("periodLabel1")
    PERIOD_LABEL_1("periodLabel1"),
    @XmlEnumValue("periodLabel2")
    PERIOD_LABEL_2("periodLabel2"),
    @XmlEnumValue("selectedTimeBlock")
    SELECTED_TIME_BLOCK("selectedTimeBlock"),
    @XmlEnumValue("unselectedTimeBlock")
    UNSELECTED_TIME_BLOCK("unselectedTimeBlock"),
    @XmlEnumValue("selectedTimeBlockSpace")
    SELECTED_TIME_BLOCK_SPACE("selectedTimeBlockSpace");
    private final String value;

    STTimelineStyleType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static STTimelineStyleType fromValue(String v) {
        for (STTimelineStyleType c: STTimelineStyleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
