/*
 *  Copyright 2010-2012, Plutext Pty Ltd.
 *
 *  This file is part of pptx4j, a component of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */
package org.pptx4j.pml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.pptx4j.pml_2012.CTPresenceInfo;
import com.openexchange.office.filter.core.INodeAccessor;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.DLNode;


/**
 * <p>Java class for CT_CommentAuthorList complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_CommentAuthorList">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="cmAuthor" type="{http://schemas.openxmlformats.org/presentationml/2006/main}CT_CommentAuthor" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_CommentAuthorList", propOrder = {
    "content"
})
@XmlRootElement(name = "cmAuthorLst")
public class CTCommentAuthorList implements INodeAccessor<CTCommentAuthor> {

    @XmlElementRefs({
        @XmlElementRef(name = "cmAuthor", namespace = "http://schemas.openxmlformats.org/presentationml/2006/main", type = CTCommentAuthor.class),
    })
    protected DLList<CTCommentAuthor> content;

    @Override
    public DLList<CTCommentAuthor> getContent() {
        if (content== null) {
            content = new DLList<CTCommentAuthor>();
        }
        return content;
    }

    public CTCommentAuthor getCommentAuthor(long id) {
        DLNode<CTCommentAuthor> commentAuthorNode = getContent().getFirstNode();
        while(commentAuthorNode!=null) {
            if(commentAuthorNode.getData().getId()==id) {
                return commentAuthorNode.getData();
            }
            commentAuthorNode = commentAuthorNode.getNext();
        }
        return null;
    }

    public CTCommentAuthor getCommentAuthor(String author, String initials, String providerId, String userId, boolean forceCreate) {
        DLNode<CTCommentAuthor> commentAuthorNode = getContent().getFirstNode();
        long id = 1;

        final boolean checkProviderId = providerId!=null&&!providerId.isEmpty()&&userId!=null&&!userId.isEmpty();
        while(commentAuthorNode!=null) {
            final CTCommentAuthor commentAuthor = commentAuthorNode.getData();
            if(checkProviderId) {
                final CTPresenceInfo presenceInfo = commentAuthor.getPresenceInfo(false);
                if(presenceInfo!=null) {
                    if(providerId.equals(presenceInfo.getProviderId())&& userId.equals(presenceInfo.getUserId())) {
                        return commentAuthor;
                    }
                }
            }
            else if(author.equals(commentAuthor.getName()) && initials.equals(commentAuthor.getInitials())) {
                return commentAuthor;
            }
            if(commentAuthor.getId()==id) {
                id++;
            }
            commentAuthorNode = commentAuthorNode.getNext();
        }
        if(forceCreate) {
            final CTCommentAuthor commentAuthor = new CTCommentAuthor();

            while(hasId(id)) {
                id++;
            }
            commentAuthor.setId(id);
            commentAuthor.setName(author);
            commentAuthor.setInitials(initials);
            getContent().add(commentAuthor);
            if(checkProviderId) {
                final CTPresenceInfo presenceInfo = commentAuthor.getPresenceInfo(true);
                presenceInfo.setProviderId(providerId);
                presenceInfo.setUserId(userId);
            }
            return commentAuthor;
        }
        return null;
    }

    private boolean hasId(long id) {
        DLNode<CTCommentAuthor> commentAuthorNode = getContent().getFirstNode();
        while(commentAuthorNode!=null) {
            if(commentAuthorNode.getData().getId()==id) {
                return true;
            }
            commentAuthorNode = commentAuthorNode.getNext();
        }
        return false;
    }

    public long getNextIdx() {
        long nextIdx = 1;
        DLNode<CTCommentAuthor> commentAuthorNode = getContent().getFirstNode();
        while (commentAuthorNode!=null) {
            long lastIdx = commentAuthorNode.getData().getLastIdx();
            if(lastIdx>=nextIdx) {
                nextIdx = lastIdx+1;
            }
            commentAuthorNode = commentAuthorNode.getNext();
        }
        return nextIdx;
    }
}
