/*
 *  Copyright 2007-2013, Plutext Pty Ltd.
 *   
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


package org.docx4j.wml; 

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>Java class for CT_Language complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CT_Language">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="val" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}ST_Lang" />
 *       &lt;attribute name="eastAsia" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}ST_Lang" />
 *       &lt;attribute name="bidi" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}ST_Lang" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_Language")
public class CTLanguage implements Cloneable {

    @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected String val;
    @XmlAttribute(name = "eastAsia", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected String eastAsia;
    @XmlAttribute(name = "bidi", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected String bidi;

    /**
     * Gets the value of the val property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVal() {
        return val;
    }

    /**
     * Sets the value of the val property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVal(String value) {
        this.val = value;
    }

    /**
     * Gets the value of the eastAsia property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEastAsia() {
        return eastAsia;
    }

    /**
     * Sets the value of the eastAsia property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEastAsia(String value) {
        this.eastAsia = value;
    }

    /**
     * Gets the value of the bidi property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBidi() {
        return bidi;
    }

    /**
     * Sets the value of the bidi property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBidi(String value) {
        this.bidi = value;
    }

    public boolean isEmpty() {
    	return val==null&&eastAsia==null&&bidi==null;
    }

    @Override
    public CTLanguage clone() {
        try {
            return (CTLanguage)super.clone();
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((bidi == null) ? 0 : bidi.hashCode());
        result = prime * result + ((eastAsia == null) ? 0 : eastAsia.hashCode());
        result = prime * result + ((val == null) ? 0 : val.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CTLanguage other = (CTLanguage) obj;
        if (bidi == null) {
            if (other.bidi != null)
                return false;
        } else if (!bidi.equals(other.bidi))
            return false;
        if (eastAsia == null) {
            if (other.eastAsia != null)
                return false;
        } else if (!eastAsia.equals(other.eastAsia))
            return false;
        if (val == null) {
            if (other.val != null)
                return false;
        } else if (!val.equals(other.val))
            return false;
        return true;
    }
//
}
