/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml2010;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;
import org.docx4j.dml.CTEffectProperties;
import org.docx4j.dml.CTFillProperties;
import org.docx4j.dml.CTLineProperties;
import org.docx4j.dml.CTScene3D;
import org.docx4j.dml.CTShape3D;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.docx4j.dml2010 package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _HiddenScene3D_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "hiddenScene3d");
    private final static QName _ShadowObscured_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "shadowObscured");
    private final static QName _M_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "m");
    private final static QName _HiddenLine_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "hiddenLine");
    private final static QName _ImgProps_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "imgProps");
    private final static QName _HiddenEffects_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "hiddenEffects");
    private final static QName _IsCanvas_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "isCanvas");
    private final static QName _ContentPart_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "contentPart");
    private final static QName _HiddenSp3D_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "hiddenSp3d");
    private final static QName _CameraTool_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "cameraTool");
    private final static QName _UseLocalDpi_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "useLocalDpi");
    private final static QName _CompatExt_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "compatExt");
    private final static QName _HiddenFill_QNAME = new QName("http://schemas.microsoft.com/office/drawing/2010/main", "hiddenFill");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.docx4j.dml2010
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link CTUseLocalDpi }
     * 
     */
    public CTUseLocalDpi createCTUseLocalDpi() {
        return new CTUseLocalDpi();
    }

    /**
     * Create an instance of {@link CTCameraTool }
     * 
     */
    public CTCameraTool createCTCameraTool() {
        return new CTCameraTool();
    }

    /**
     * Create an instance of {@link CTTextMath }
     * 
     */
    public CTTextMath createCTTextMath() {
        return new CTTextMath();
    }

    /**
     * Create an instance of {@link CTGvmlContentPart }
     * 
     */
    public CTGvmlContentPart createCTGvmlContentPart() {
        return new CTGvmlContentPart();
    }

    /**
     * Create an instance of {@link CTCompatExt }
     * 
     */
    public CTCompatExt createCTCompatExt() {
        return new CTCompatExt();
    }

    /**
     * Create an instance of {@link CTShadowObscured }
     * 
     */
    public CTShadowObscured createCTShadowObscured() {
        return new CTShadowObscured();
    }

    /**
     * Create an instance of {@link CTIsGvmlCanvas }
     * 
     */
    public CTIsGvmlCanvas createCTIsGvmlCanvas() {
        return new CTIsGvmlCanvas();
    }

    /**
     * Create an instance of {@link CTPhoto }
     * 
     */
    public CTPhoto createCTPhoto() {
        return new CTPhoto();
    }

    /**
     * Create an instance of {@link CTPictureEffectPhotocopy }
     * 
     */
    public CTPictureEffectPhotocopy createCTPictureEffectPhotocopy() {
        return new CTPictureEffectPhotocopy();
    }

    /**
     * Create an instance of {@link CTPictureEffectSharpenSoften }
     * 
     */
    public CTPictureEffectSharpenSoften createCTPictureEffectSharpenSoften() {
        return new CTPictureEffectSharpenSoften();
    }

    /**
     * Create an instance of {@link CTPictureEffectGlass }
     * 
     */
    public CTPictureEffectGlass createCTPictureEffectGlass() {
        return new CTPictureEffectGlass();
    }

    /**
     * Create an instance of {@link CTPictureEffectWatercolorSponge }
     * 
     */
    public CTPictureEffectWatercolorSponge createCTPictureEffectWatercolorSponge() {
        return new CTPictureEffectWatercolorSponge();
    }

    /**
     * Create an instance of {@link CTNonVisualInkContentPartProperties }
     * 
     */
    public CTNonVisualInkContentPartProperties createCTNonVisualInkContentPartProperties() {
        return new CTNonVisualInkContentPartProperties();
    }

    /**
     * Create an instance of {@link CTPictureEffectCement }
     * 
     */
    public CTPictureEffectCement createCTPictureEffectCement() {
        return new CTPictureEffectCement();
    }

    /**
     * Create an instance of {@link CTPictureEffectBackgroundRemoval }
     * 
     */
    public CTPictureEffectBackgroundRemoval createCTPictureEffectBackgroundRemoval() {
        return new CTPictureEffectBackgroundRemoval();
    }

    /**
     * Create an instance of {@link CTPictureEffectBlur }
     * 
     */
    public CTPictureEffectBlur createCTPictureEffectBlur() {
        return new CTPictureEffectBlur();
    }

    /**
     * Create an instance of {@link CTPictureEffectCutout }
     * 
     */
    public CTPictureEffectCutout createCTPictureEffectCutout() {
        return new CTPictureEffectCutout();
    }

    /**
     * Create an instance of {@link CTPictureEffect }
     * 
     */
    public CTPictureEffect createCTPictureEffect() {
        return new CTPictureEffect();
    }

    /**
     * Create an instance of {@link CTPictureEffectPencilGrayscale }
     * 
     */
    public CTPictureEffectPencilGrayscale createCTPictureEffectPencilGrayscale() {
        return new CTPictureEffectPencilGrayscale();
    }

    /**
     * Create an instance of {@link CTPictureEffectSaturation }
     * 
     */
    public CTPictureEffectSaturation createCTPictureEffectSaturation() {
        return new CTPictureEffectSaturation();
    }

    /**
     * Create an instance of {@link CTPictureEffectLightScreen }
     * 
     */
    public CTPictureEffectLightScreen createCTPictureEffectLightScreen() {
        return new CTPictureEffectLightScreen();
    }

    /**
     * Create an instance of {@link CTPictureEffectBrightnessContrast }
     * 
     */
    public CTPictureEffectBrightnessContrast createCTPictureEffectBrightnessContrast() {
        return new CTPictureEffectBrightnessContrast();
    }

    /**
     * Create an instance of {@link CTPictureEffectMarker }
     * 
     */
    public CTPictureEffectMarker createCTPictureEffectMarker() {
        return new CTPictureEffectMarker();
    }

    /**
     * Create an instance of {@link CTPictureEffectMosiaicBubbles }
     * 
     */
    public CTPictureEffectMosiaicBubbles createCTPictureEffectMosiaicBubbles() {
        return new CTPictureEffectMosiaicBubbles();
    }

    /**
     * Create an instance of {@link CTPictureEffectChalkSketch }
     * 
     */
    public CTPictureEffectChalkSketch createCTPictureEffectChalkSketch() {
        return new CTPictureEffectChalkSketch();
    }

    /**
     * Create an instance of {@link CTContentPartLocking }
     * 
     */
    public CTContentPartLocking createCTContentPartLocking() {
        return new CTContentPartLocking();
    }

    /**
     * Create an instance of {@link CTPictureLayer }
     * 
     */
    public CTPictureLayer createCTPictureLayer() {
        return new CTPictureLayer();
    }

    /**
     * Create an instance of {@link CTPictureEffectPencilSketch }
     * 
     */
    public CTPictureEffectPencilSketch createCTPictureEffectPencilSketch() {
        return new CTPictureEffectPencilSketch();
    }

    /**
     * Create an instance of {@link CTPictureEffectFilmGrain }
     * 
     */
    public CTPictureEffectFilmGrain createCTPictureEffectFilmGrain() {
        return new CTPictureEffectFilmGrain();
    }

    /**
     * Create an instance of {@link CTPictureEffectBackgroundRemovalBackgroundMark }
     * 
     */
    public CTPictureEffectBackgroundRemovalBackgroundMark createCTPictureEffectBackgroundRemovalBackgroundMark() {
        return new CTPictureEffectBackgroundRemovalBackgroundMark();
    }

    /**
     * Create an instance of {@link CTPictureEffectPastelsSmooth }
     * 
     */
    public CTPictureEffectPastelsSmooth createCTPictureEffectPastelsSmooth() {
        return new CTPictureEffectPastelsSmooth();
    }

    /**
     * Create an instance of {@link CTPictureEffectGlowDiffused }
     * 
     */
    public CTPictureEffectGlowDiffused createCTPictureEffectGlowDiffused() {
        return new CTPictureEffectGlowDiffused();
    }

    /**
     * Create an instance of {@link CTPictureEffectTexturizer }
     * 
     */
    public CTPictureEffectTexturizer createCTPictureEffectTexturizer() {
        return new CTPictureEffectTexturizer();
    }

    /**
     * Create an instance of {@link CTPictureEffectPlasticWrap }
     * 
     */
    public CTPictureEffectPlasticWrap createCTPictureEffectPlasticWrap() {
        return new CTPictureEffectPlasticWrap();
    }

    /**
     * Create an instance of {@link CTPictureEffectLineDrawing }
     * 
     */
    public CTPictureEffectLineDrawing createCTPictureEffectLineDrawing() {
        return new CTPictureEffectLineDrawing();
    }

    /**
     * Create an instance of {@link CTPictureEffectBackgroundRemovalForegroundMark }
     * 
     */
    public CTPictureEffectBackgroundRemovalForegroundMark createCTPictureEffectBackgroundRemovalForegroundMark() {
        return new CTPictureEffectBackgroundRemovalForegroundMark();
    }

    /**
     * Create an instance of {@link CTPictureEffectCrisscrossEtching }
     * 
     */
    public CTPictureEffectCrisscrossEtching createCTPictureEffectCrisscrossEtching() {
        return new CTPictureEffectCrisscrossEtching();
    }

    /**
     * Create an instance of {@link CTPictureEffectPaintBrush }
     * 
     */
    public CTPictureEffectPaintBrush createCTPictureEffectPaintBrush() {
        return new CTPictureEffectPaintBrush();
    }

    /**
     * Create an instance of {@link CTPictureEffectPaintStrokes }
     * 
     */
    public CTPictureEffectPaintStrokes createCTPictureEffectPaintStrokes() {
        return new CTPictureEffectPaintStrokes();
    }

    /**
     * Create an instance of {@link CTGvmlContentPartNonVisual }
     * 
     */
    public CTGvmlContentPartNonVisual createCTGvmlContentPartNonVisual() {
        return new CTGvmlContentPartNonVisual();
    }

    /**
     * Create an instance of {@link CTPictureEffectColorTemperature }
     * 
     */
    public CTPictureEffectColorTemperature createCTPictureEffectColorTemperature() {
        return new CTPictureEffectColorTemperature();
    }

    /**
     * Create an instance of {@link CTPictureEffectGlowEdges }
     * 
     */
    public CTPictureEffectGlowEdges createCTPictureEffectGlowEdges() {
        return new CTPictureEffectGlowEdges();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTScene3D }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "hiddenScene3d")
    public JAXBElement<CTScene3D> createHiddenScene3D(CTScene3D value) {
        return new JAXBElement<CTScene3D>(_HiddenScene3D_QNAME, CTScene3D.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTShadowObscured }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "shadowObscured")
    public JAXBElement<CTShadowObscured> createShadowObscured(CTShadowObscured value) {
        return new JAXBElement<CTShadowObscured>(_ShadowObscured_QNAME, CTShadowObscured.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTTextMath }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "m")
    public JAXBElement<CTTextMath> createM(CTTextMath value) {
        return new JAXBElement<CTTextMath>(_M_QNAME, CTTextMath.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTLineProperties }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "hiddenLine")
    public JAXBElement<CTLineProperties> createHiddenLine(CTLineProperties value) {
        return new JAXBElement<CTLineProperties>(_HiddenLine_QNAME, CTLineProperties.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTPhoto }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "imgProps")
    public JAXBElement<CTPhoto> createImgProps(CTPhoto value) {
        return new JAXBElement<CTPhoto>(_ImgProps_QNAME, CTPhoto.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTEffectProperties }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "hiddenEffects")
    public JAXBElement<CTEffectProperties> createHiddenEffects(CTEffectProperties value) {
        return new JAXBElement<CTEffectProperties>(_HiddenEffects_QNAME, CTEffectProperties.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTIsGvmlCanvas }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "isCanvas")
    public JAXBElement<CTIsGvmlCanvas> createIsCanvas(CTIsGvmlCanvas value) {
        return new JAXBElement<CTIsGvmlCanvas>(_IsCanvas_QNAME, CTIsGvmlCanvas.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTGvmlContentPart }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "contentPart")
    public JAXBElement<CTGvmlContentPart> createContentPart(CTGvmlContentPart value) {
        return new JAXBElement<CTGvmlContentPart>(_ContentPart_QNAME, CTGvmlContentPart.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTShape3D }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "hiddenSp3d")
    public JAXBElement<CTShape3D> createHiddenSp3D(CTShape3D value) {
        return new JAXBElement<CTShape3D>(_HiddenSp3D_QNAME, CTShape3D.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTCameraTool }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "cameraTool")
    public JAXBElement<CTCameraTool> createCameraTool(CTCameraTool value) {
        return new JAXBElement<CTCameraTool>(_CameraTool_QNAME, CTCameraTool.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTUseLocalDpi }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "useLocalDpi")
    public JAXBElement<CTUseLocalDpi> createUseLocalDpi(CTUseLocalDpi value) {
        return new JAXBElement<CTUseLocalDpi>(_UseLocalDpi_QNAME, CTUseLocalDpi.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTCompatExt }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "compatExt")
    public JAXBElement<CTCompatExt> createCompatExt(CTCompatExt value) {
        return new JAXBElement<CTCompatExt>(_CompatExt_QNAME, CTCompatExt.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTFillProperties }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://schemas.microsoft.com/office/drawing/2010/main", name = "hiddenFill")
    public JAXBElement<CTFillProperties> createHiddenFill(CTFillProperties value) {
        return new JAXBElement<CTFillProperties>(_HiddenFill_QNAME, CTFillProperties.class, null, value);
    }

}
