
/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml.chartex2014;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.docx4j.dml.CTShapeProperties;
import org.docx4j.dml.CTTextBody;


/**
 * <p>Java class for CT_Axis complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CT_Axis">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;choice>
 *           &lt;element name="catScaling" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_CategoryAxisScaling"/>
 *           &lt;element name="valScaling" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_ValueAxisScaling"/>
 *         &lt;/choice>
 *         &lt;element name="title" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_AxisTitle" minOccurs="0"/>
 *         &lt;element name="units" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_AxisUnits" minOccurs="0"/>
 *         &lt;element name="majorGridlines" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_Gridlines" minOccurs="0"/>
 *         &lt;element name="minorGridlines" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_Gridlines" minOccurs="0"/>
 *         &lt;element name="majorTickMarks" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_TickMarks" minOccurs="0"/>
 *         &lt;element name="minorTickMarks" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_TickMarks" minOccurs="0"/>
 *         &lt;element name="tickLabels" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_TickLabels" minOccurs="0"/>
 *         &lt;element name="numFmt" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_NumberFormat" minOccurs="0"/>
 *         &lt;element name="spPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_ShapeProperties" minOccurs="0"/>
 *         &lt;element name="txPr" type="{http://schemas.openxmlformats.org/drawingml/2006/main}CT_TextBody" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://schemas.microsoft.com/office/drawing/2014/chartex}ST_AxisId" />
 *       &lt;attribute name="hidden" type="{http://www.w3.org/2001/XMLSchema}boolean" default="0" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_Axis", propOrder = {
    "catScaling",
    "valScaling",
    "title",
    "units",
    "majorGridlines",
    "minorGridlines",
    "majorTickMarks",
    "minorTickMarks",
    "tickLabels",
    "numFmt",
    "spPr",
    "txPr",
    "extLst"
})
public class CTAxis {

    protected CTCategoryAxisScaling catScaling;
    protected CTValueAxisScaling valScaling;
    protected CTAxisTitle title;
    protected CTAxisUnits units;
    protected CTGridlines majorGridlines;
    protected CTGridlines minorGridlines;
    protected CTTickMarks majorTickMarks;
    protected CTTickMarks minorTickMarks;
    protected CTTickLabels tickLabels;
    protected CTNumberFormat numFmt;
    protected CTShapeProperties spPr;
    protected CTTextBody txPr;
    protected CTExtensionList extLst;
    @XmlAttribute(name = "id", required = true)
    protected long id;
    @XmlAttribute(name = "hidden")
    protected Boolean hidden;

    /**
     * Gets the value of the catScaling property.
     * 
     * @return
     *     possible object is
     *     {@link CTCategoryAxisScaling }
     *     
     */
    public CTCategoryAxisScaling getCatScaling() {
        return catScaling;
    }

    /**
     * Sets the value of the catScaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTCategoryAxisScaling }
     *     
     */
    public void setCatScaling(CTCategoryAxisScaling value) {
        this.catScaling = value;
    }

    /**
     * Gets the value of the valScaling property.
     * 
     * @return
     *     possible object is
     *     {@link CTValueAxisScaling }
     *     
     */
    public CTValueAxisScaling getValScaling() {
        return valScaling;
    }

    /**
     * Sets the value of the valScaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTValueAxisScaling }
     *     
     */
    public void setValScaling(CTValueAxisScaling value) {
        this.valScaling = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link CTAxisTitle }
     *     
     */
    public CTAxisTitle getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTAxisTitle }
     *     
     */
    public void setTitle(CTAxisTitle value) {
        this.title = value;
    }

    /**
     * Gets the value of the units property.
     * 
     * @return
     *     possible object is
     *     {@link CTAxisUnits }
     *     
     */
    public CTAxisUnits getUnits() {
        return units;
    }

    /**
     * Sets the value of the units property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTAxisUnits }
     *     
     */
    public void setUnits(CTAxisUnits value) {
        this.units = value;
    }

    /**
     * Gets the value of the majorGridlines property.
     * 
     * @return
     *     possible object is
     *     {@link CTGridlines }
     *     
     */
    public CTGridlines getMajorGridlines() {
        return majorGridlines;
    }

    /**
     * Sets the value of the majorGridlines property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTGridlines }
     *     
     */
    public void setMajorGridlines(CTGridlines value) {
        this.majorGridlines = value;
    }

    /**
     * Gets the value of the minorGridlines property.
     * 
     * @return
     *     possible object is
     *     {@link CTGridlines }
     *     
     */
    public CTGridlines getMinorGridlines() {
        return minorGridlines;
    }

    /**
     * Sets the value of the minorGridlines property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTGridlines }
     *     
     */
    public void setMinorGridlines(CTGridlines value) {
        this.minorGridlines = value;
    }

    /**
     * Gets the value of the majorTickMarks property.
     * 
     * @return
     *     possible object is
     *     {@link CTTickMarks }
     *     
     */
    public CTTickMarks getMajorTickMarks() {
        return majorTickMarks;
    }

    /**
     * Sets the value of the majorTickMarks property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTTickMarks }
     *     
     */
    public void setMajorTickMarks(CTTickMarks value) {
        this.majorTickMarks = value;
    }

    /**
     * Gets the value of the minorTickMarks property.
     * 
     * @return
     *     possible object is
     *     {@link CTTickMarks }
     *     
     */
    public CTTickMarks getMinorTickMarks() {
        return minorTickMarks;
    }

    /**
     * Sets the value of the minorTickMarks property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTTickMarks }
     *     
     */
    public void setMinorTickMarks(CTTickMarks value) {
        this.minorTickMarks = value;
    }

    /**
     * Gets the value of the tickLabels property.
     * 
     * @return
     *     possible object is
     *     {@link CTTickLabels }
     *     
     */
    public CTTickLabels getTickLabels() {
        return tickLabels;
    }

    /**
     * Sets the value of the tickLabels property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTTickLabels }
     *     
     */
    public void setTickLabels(CTTickLabels value) {
        this.tickLabels = value;
    }

    /**
     * Gets the value of the numFmt property.
     * 
     * @return
     *     possible object is
     *     {@link CTNumberFormat }
     *     
     */
    public CTNumberFormat getNumFmt() {
        return numFmt;
    }

    /**
     * Sets the value of the numFmt property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTNumberFormat }
     *     
     */
    public void setNumFmt(CTNumberFormat value) {
        this.numFmt = value;
    }

    /**
     * Gets the value of the spPr property.
     * 
     * @return
     *     possible object is
     *     {@link CTShapeProperties }
     *     
     */
    public CTShapeProperties getSpPr() {
        return spPr;
    }

    /**
     * Sets the value of the spPr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTShapeProperties }
     *     
     */
    public void setSpPr(CTShapeProperties value) {
        this.spPr = value;
    }

    /**
     * Gets the value of the txPr property.
     * 
     * @return
     *     possible object is
     *     {@link CTTextBody }
     *     
     */
    public CTTextBody getTxPr() {
        return txPr;
    }

    /**
     * Sets the value of the txPr property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTTextBody }
     *     
     */
    public void setTxPr(CTTextBody value) {
        this.txPr = value;
    }

    /**
     * Gets the value of the extLst property.
     * 
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *     
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     * 
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *     
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

    /**
     * Gets the value of the id property.
     * 
     */
    public long getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     */
    public void setId(long value) {
        this.id = value;
    }

    /**
     * Gets the value of the hidden property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isHidden() {
        if (hidden == null) {
            return false;
        } else {
            return hidden;
        }
    }

    /**
     * Sets the value of the hidden property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHidden(Boolean value) {
        this.hidden = value;
    }

}
