/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.document;

import com.openexchange.office.tools.doc.ApplicationType;
import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.doc.DocumentFormatHelper.OfficeDocumentType;
import com.openexchange.office.tools.doc.DocumentType;
import com.openexchange.office.tools.doc.MimeTypeHelper;

public class OfficeDocumentTypeProperties {

    //-------------------------------------------------------------------------
    private String mimeType;
    private String module;
    private String extension;
    private OfficeDocumentType docType;
    private DocumentFormat docFormat;

    //-------------------------------------------------------------------------
    private OfficeDocumentTypeProperties(String mimeType, String module, String extension, OfficeDocumentType docType, DocumentFormat docFormat) {
        this.mimeType = mimeType;
        this.module = module;
        this.extension = extension;
        this.docType = docType;
        this.docFormat = docFormat;
    }

    //-------------------------------------------------------------------------
    public String getMimeType() { return mimeType; }

    //-------------------------------------------------------------------------
    public String getModule() { return module; }

    //-------------------------------------------------------------------------
    public String getExtension() { return extension; }

    //-------------------------------------------------------------------------
    public OfficeDocumentType getOfficeDocumentType() { return docType; }

    //-------------------------------------------------------------------------
    public DocumentFormat getDocumentFormat() { return docFormat; }

    //-------------------------------------------------------------------------
    static public OfficeDocumentTypeProperties determineDefaultOfficeProperties(String docTypeName) {
        String mimeType;
        String module;
        String extensionType;
        DocumentFormat docFormat;
        OfficeDocumentType officeDocumentType;

        if (docTypeName.equals(ApplicationType.APP_SPREADSHEET_STRING)) {
            module             = ApplicationType.APP_SPREADSHEET_STRING;
            officeDocumentType = OfficeDocumentType.MS_DOCUMENT_SPREADSHEET;
            docFormat          = DocumentFormat.XLSX;
            extensionType      = "xlsx";
            mimeType           = MimeTypeHelper.MIMETYPE_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEET;
        } else if (docTypeName.equals(ApplicationType.APP_PRESENTATION_STRING)) {
            module             = ApplicationType.APP_PRESENTATION_STRING;
            officeDocumentType = OfficeDocumentType.MS_DOCUMENT_PRESENTATION;
            docFormat          = DocumentFormat.PPTX;
            extensionType      = "pptx";
            mimeType           = MimeTypeHelper.MIMETYPE_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATION;
        } else {
            module             = ApplicationType.APP_TEXT_STRING;
            officeDocumentType = OfficeDocumentType.MS_DOCUMENT_WORD;
            extensionType      = "docx";
            docFormat          = DocumentFormat.DOCX;
            mimeType           = MimeTypeHelper.MIMETYPE_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSING;
        }

        return new OfficeDocumentTypeProperties(mimeType, module, extensionType, officeDocumentType, docFormat);
    }

}
