package com.openexchange.office.dcs.registry.config;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;

public class JMSConfigReadEvent extends EventObject {

    private final Set<DCSRegistryItem> eventData;

    public JMSConfigReadEvent(Object source, Collection<DCSRegistryItem> eventData) {
        super(source);
        this.eventData = Collections.unmodifiableSet(new HashSet<>(eventData));
    }

    public Set<DCSRegistryItem> getEventData() {
        return eventData;
    }
}
