/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.method.HandlerTypePredicate;

public class ControllerAdviceBean
implements Ordered {
    private final Object bean;
    @Nullable
    private final BeanFactory beanFactory;
    private final int order;
    private final HandlerTypePredicate beanTypePredicate;

    public ControllerAdviceBean(Object bean2) {
        this(bean2, null);
    }

    public ControllerAdviceBean(String beanName, @Nullable BeanFactory beanFactory) {
        this((Object)beanName, beanFactory);
    }

    private ControllerAdviceBean(Object bean2, @Nullable BeanFactory beanFactory) {
        Class<?> beanType;
        this.bean = bean2;
        this.beanFactory = beanFactory;
        if (bean2 instanceof String) {
            String beanName = (String)bean2;
            Assert.hasText(beanName, "Bean name must not be null");
            Assert.notNull((Object)beanFactory, "BeanFactory must not be null");
            if (!beanFactory.containsBean(beanName)) {
                throw new IllegalArgumentException("BeanFactory [" + beanFactory + "] does not contain specified controller advice bean '" + beanName + "'");
            }
            beanType = this.beanFactory.getType(beanName);
            this.order = ControllerAdviceBean.initOrderFromBeanType(beanType);
        } else {
            Assert.notNull(bean2, "Bean must not be null");
            beanType = bean2.getClass();
            this.order = ControllerAdviceBean.initOrderFromBean(bean2);
        }
        ControllerAdvice annotation = beanType != null ? AnnotatedElementUtils.findMergedAnnotation(beanType, ControllerAdvice.class) : null;
        this.beanTypePredicate = annotation != null ? HandlerTypePredicate.builder().basePackage(annotation.basePackages()).basePackageClass(annotation.basePackageClasses()).assignableType(annotation.assignableTypes()).annotation(annotation.annotations()).build() : HandlerTypePredicate.forAnyHandlerType();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Nullable
    public Class<?> getBeanType() {
        Class<?> beanType = this.bean instanceof String ? this.obtainBeanFactory().getType((String)this.bean) : this.bean.getClass();
        return beanType != null ? ClassUtils.getUserClass(beanType) : null;
    }

    public Object resolveBean() {
        return this.bean instanceof String ? this.obtainBeanFactory().getBean((String)this.bean) : this.bean;
    }

    private BeanFactory obtainBeanFactory() {
        Assert.state(this.beanFactory != null, "No BeanFactory set");
        return this.beanFactory;
    }

    public boolean isApplicableToBeanType(@Nullable Class<?> beanType) {
        return this.beanTypePredicate.test(beanType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ControllerAdviceBean)) {
            return false;
        }
        ControllerAdviceBean otherAdvice = (ControllerAdviceBean)other;
        return this.bean.equals(otherAdvice.bean) && this.beanFactory == otherAdvice.beanFactory;
    }

    public int hashCode() {
        return this.bean.hashCode();
    }

    public String toString() {
        return this.bean.toString();
    }

    public static List<ControllerAdviceBean> findAnnotatedBeans(ApplicationContext context) {
        return Arrays.stream(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context, Object.class)).filter(name -> context.findAnnotationOnBean((String)name, ControllerAdvice.class) != null).map(name -> new ControllerAdviceBean((String)name, (BeanFactory)context)).collect(Collectors.toList());
    }

    private static int initOrderFromBean(Object bean2) {
        return bean2 instanceof Ordered ? ((Ordered)bean2).getOrder() : ControllerAdviceBean.initOrderFromBeanType(bean2.getClass());
    }

    private static int initOrderFromBeanType(@Nullable Class<?> beanType) {
        Integer order = null;
        if (beanType != null) {
            order = OrderUtils.getOrder(beanType);
        }
        return order != null ? order : Integer.MAX_VALUE;
    }
}

