/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    @Nullable
    private ReactiveRequest reactiveRequest;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public HttpMethod getMethod() {
        HttpMethod method = HttpMethod.resolve(this.jettyRequest.getMethod());
        Assert.state(method != null, "Method must not be null");
        return method;
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(this::completes);
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> publisher) {
        Flux chunks = Flux.from(publisher).map(this::toContentChunk);
        MediaType contentType = this.getHeaders().getContentType();
        ReactiveRequest.Content requestContent = ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)(contentType != null ? contentType.toString() : "application/octet-stream"));
        this.reactiveRequest = ReactiveRequest.newBuilder((Request)this.jettyRequest).content(requestContent).build();
        return this.doCommit(this::completes);
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        String contentType = this.jettyRequest.getHeaders().getField(HttpHeader.CONTENT_TYPE).getValue();
        Flux chunks = Flux.from(body).flatMap(Function.identity()).map(this::toContentChunk);
        ReactiveRequest.Content content = ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)contentType);
        this.reactiveRequest = ReactiveRequest.newBuilder((Request)this.jettyRequest).content(content).build();
        return this.doCommit(this::completes);
    }

    private Mono<Void> completes() {
        return Mono.empty();
    }

    private ContentChunk toContentChunk(final DataBuffer buffer) {
        return new ContentChunk(buffer.asByteBuffer(), new Callback(){

            public void succeeded() {
                DataBufferUtils.release(buffer);
            }

            public void failed(Throwable x) {
                DataBufferUtils.release(buffer);
                throw Exceptions.propagate((Throwable)x);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(arg_0 -> ((Request)this.jettyRequest).cookie(arg_0));
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        headers.forEach((key, value) -> value.forEach(v -> this.jettyRequest.header(key, v)));
        if (!headers.containsKey("Accept")) {
            this.jettyRequest.header("Accept", "*/*");
        }
    }

    ReactiveRequest getReactiveRequest() {
        if (this.reactiveRequest == null) {
            this.reactiveRequest = ReactiveRequest.newBuilder((Request)this.jettyRequest).build();
        }
        return this.reactiveRequest;
    }
}

