%define use_systemd (0%{?rhel} && 0%{?rhel} >= 7) || (0%{?suse_version} && 0%{?suse_version} >=1210)

Name:          open-xchange-imageconverter-server
BuildArch:     noarch
%if 0%{?suse_version}
BuildRequires: java-1_8_0-openjdk-devel
%else
BuildRequires: java-1.8.0-openjdk-devel
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
BuildRequires: open-xchange-core >= 7.10.3
BuildRequires: open-xchange-admin-soap >= 7.10.3
BuildRequires: open-xchange-authorization-standard >= 7.10.3
BuildRequires: open-xchange-file-distribution >= 7.10.3
BuildRequires: open-xchange-filestore-s3 >= 7.10.3
BuildRequires: open-xchange-filestore-sproxyd >= 7.10.3
BuildRequires: open-xchange-grizzly >= 7.10.3
BuildRequires: open-xchange-oauth >= 7.10.3
BuildRequires: open-xchange-oauth-provider >= 7.10.3
BuildRequires: open-xchange-rest >= 7.10.3
BuildRequires: open-xchange-sessionstorage-hazelcast >= 7.10.3
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
BuildRequires:    systemd-rpm-macros
%endif
Version:       7.10.3
%define        ox_release 4
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Source1:       open-xchange-imageconverter-server.init
Source2:       open-xchange-imageconverter-server.service
%define        dropin_dir /etc/systemd/system/open-xchange-imageconverter-server.service.d
%define        dropin_example limits.conf
Summary:       The Open-Xchange webservice for image conversion
AutoReqProv:   no
Requires:      gawk
Requires:      curl
Requires:      sed
Requires:      open-xchange-core >= 7.10.3
Requires:      open-xchange-admin-soap >= 7.10.3
Requires:      open-xchange-file-distribution >= 7.10.3
Requires:      open-xchange-filestore-s3 >= 7.10.3
Requires:      open-xchange-filestore-sproxyd >= 7.10.3
Requires:      open-xchange-grizzly >= 7.10.3
Requires:      open-xchange-rest >= 7.10.3
Provides:      open-xchange-imageconverter-server = %{version}
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
Requires(pre):    systemd
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%endif

%description
This package contains the backend components for the ImageConverter web service

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange/imageconverter
mkdir -p %{buildroot}/var/spool/open-xchange/fileitem
mkdir -p %{buildroot}/var/spool/open-xchange/imageconverter
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%__install -D -m 444 %{SOURCE2} %{buildroot}/usr/lib/systemd/system/open-xchange-imageconverter-server.service
%else
mkdir -p %{buildroot}/etc/init.d
install -m 755 %{SOURCE1} %{buildroot}/etc/init.d/open-xchange-imageconverter-server
%endif

# On Redhat and SuSE start scripts are not automatically added to system start. This is wanted behavior and standard.

%post
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_add_post open-xchange-imageconverter-server.service
%endif
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}-%{version}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
if [ ! -f %{dropin_dir}/%{dropin_example} ]
then
  install -D -m 644 %{_defaultdocdir}/%{name}/%{dropin_example} %{dropin_dir}/%{dropin_example}
fi
%endif

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && grep -q "^#LimitNOFILE=16384$" ${drop_in}
then
  sed -i 's/^#LimitNOFILE=16384$/#LimitNOFILE=65536/' ${drop_in}
fi

drop_in=%{dropin_dir}/%{dropin_example}
if [ -f ${drop_in} ] && ! grep -q LimitNPROC ${drop_in}
then
  sed -i '/^\[Service\]$/a #LimitNPROC=65536' ${drop_in}
fi

# Trigger a service definition/config reload
%if %{use_systemd}
systemctl daemon-reload &> /dev/null || :
%endif

if [ ${1:-0} -eq 2 ]; then 
    # only when updating

    . /opt/open-xchange/lib/oxfunctions.sh

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    SCR=SCR-438
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      ox_add_property com.openexchange.imageconverter.convertTimeoutMillis 15000 ${pfile}
      ox_scr_done ${SCR}
    }

    SCR=SCR-439
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      ox_add_property com.openexchange.imageconverter.errorPath "" ${pfile}
      ox_scr_done ${SCR}
    }

    SCR=SCR-458
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/imageconverter.properties
      pkey=com.openexchange.imageconverter.targetFormats
      new_val_part=auto:1920x1080~cover
      curr_formats=$(ox_read_property ${pkey} ${pfile})
      if [[ ! ${curr_formats} =~ ${new_val_part} ]]
      then
        new_val="${curr_formats}, ${new_val_part}"
        ox_set_property ${pkey} "${new_val}" ${pfile}
      fi
      ox_scr_done ${SCR}
    }

    SCR=SCR-476
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/imageconverter/etc/overwrite.properties
      pkey=com.openexchange.hazelcast.enabled
      new_val=false
      ox_add_property ${pkey} "${new_val}" ${pfile}
      ox_scr_done ${SCR}
    }

fi

%preun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_preun open-xchange-imageconverter-server.service
%endif

%postun
%if (0%{?suse_version} && 0%{?suse_version} >= 1210)
%service_del_postun open-xchange-imageconverter-server.service
%endif

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/imageconverter
%dir /opt/open-xchange/imageconverter/bundles/
/opt/open-xchange/imageconverter/bundles/*
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/osgi/
/opt/open-xchange/imageconverter/osgi/config.ini.template
%dir /opt/open-xchange/imageconverter/osgi/bundle.d/
/opt/open-xchange/imageconverter/osgi/bundle.d/*
%dir /opt/open-xchange/imageconverter/etc/
%config(noreplace) /opt/open-xchange/imageconverter/etc/fileitem.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/imageconverter.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/logback.xml
%config(noreplace) /opt/open-xchange/imageconverter/etc/overwrite.properties
%config(noreplace) /opt/open-xchange/imageconverter/etc/process-conf.sh
%dir /opt/open-xchange/imageconverter/etc/security
/opt/open-xchange/imageconverter/etc/security/imageconverter.list
%dir /opt/open-xchange/imageconverter/etc/magick
/opt/open-xchange/imageconverter/etc/magick/policy.xml
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/lib/
%attr(0755,root,root) /opt/open-xchange/imageconverter/lib/com.openexchange.imageconverter.clt.jar
%dir %attr(750, open-xchange, root) /opt/open-xchange/imageconverter/sbin/
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/imageconverter-admin
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/initfileitemdb
%attr(0755,root,root) /opt/open-xchange/imageconverter/sbin/open-xchange-imageconverter
%dir %attr(750, open-xchange, root) /var/log/open-xchange/imageconverter
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/fileitem
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/imageconverter
%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
/usr/lib/systemd/system/open-xchange-imageconverter-server.service
%else
/etc/init.d/open-xchange-imageconverter-server
%endif

%if (0%{?rhel_version} && 0%{?rhel_version} >= 700) || (0%{?suse_version} && 0%{?suse_version} >= 1210)
%doc docs/%{dropin_example}
%endif

%changelog
* Tue Feb 02 2021 Kai Ahrens <kai.ahrens@open-xchange.com>
Build for patch 2021-02-08 (5944)
* Thu Nov 28 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
Second candidate of 7.10.3 release
* Thu Nov 21 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
First candidate of 7.10.3 release
* Thu Oct 17 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.3 release
* Wed Jun 19 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
prepare for 7.10.3 release
* Fri May 10 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
First candidate of 7.10.2 release
* Thu May 02 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
Second preview of 7.10.2 release
* Thu Mar 28 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.2 release
* Mon Mar 11 2019 Kai Ahrens <kai.ahrens@open-xchange.com>
prepare for 7.10.2
* Fri Nov 23 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
RC 1 for 7.10.1 release
* Fri Nov 02 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Second preview for 7.10.1 release
* Thu Oct 11 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview for 7.10.1 release
* Mon Sep 10 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
prepare for 7.10.1
* Mon Jun 25 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Second candidate for 7.10.0 release
* Mon Jun 11 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
First candidate for 7.10.0 release
* Fri May 18 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Sixth preview of 7.10.0 release
* Thu Apr 19 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Fifth preview of 7.10.0 release
* Tue Apr 03 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Third preview of 7.10.0 release
* Tue Feb 20 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
Second preview of 7.10.0 release
* Fri Feb 02 2018 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.0 release
* Sun Oct 22 2017 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.10.0 release
* Tue Apr 04 2017 Kai Ahrens <kai.ahrens@open-xchange.com>
First preview of 7.8.4 release
