/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.git.ant;

import com.openexchange.jgit.OXReleaseDescribeCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitDescription
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "gitDescription";
    private static final String DEFAULT_PATTERN = "\\d+\\.\\d+\\.\\d+-\\d+";
    private String mode = "shortest";
    private String propertyName;
    private String repositoryName;
    private String tagPattern;

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setTagPattern(String tagPattern) {
        this.tagPattern = null == tagPattern || tagPattern.isEmpty() || "${tagPattern}".equals(tagPattern) ? DEFAULT_PATTERN : tagPattern;
    }

    public void execute() throws BuildException {
        if (!"shortest".equals(this.mode) && !"highest".equals(this.mode)) {
            throw new BuildException("Only the modes shortest and highest are supported.");
        }
        if (this.propertyName == null) {
            this.log("Missing parameter propertyName, going to use default: gitDescription");
            this.propertyName = DEFAULT_PROPERTY_NAME;
        }
        if (this.repositoryName == null || this.repositoryName.isEmpty()) {
            throw new BuildException("Missing parameter: repositoryName");
        }
        try {
            FileRepositoryBuilder frb = new FileRepositoryBuilder();
            ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)frb.setGitDir(new File(this.repositoryName))).readEnvironment()).findGitDir()).build();
            Repository repository = frb.build();
            OXReleaseDescribeCommand ordc = new OXReleaseDescribeCommand(repository);
            if ("highest".equals(this.mode)) {
                this.log("Mode highest");
                ordc.pickHighestVersion();
            } else if (this.tagPattern != null && !this.tagPattern.isEmpty()) {
                this.log("Pattern " + this.tagPattern);
                ordc.settagPattern(this.tagPattern);
            }
            ordc.setLong(true);
            String releaseDescription = ordc.call();
            if (releaseDescription != null) {
                this.getProject().setInheritedProperty(this.propertyName, releaseDescription);
                this.log("Setting property '" + this.propertyName + "' for repository '" + this.repositoryName + "' with tagPattern '" + this.tagPattern + "' to value: " + releaseDescription);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Unable to determine git description for repo ");
                sb.append(this.repositoryName);
                sb.append(".");
                if (repository.getTags().isEmpty()) {
                    sb.append(" There are currently no tags known for this repository.");
                } else {
                    sb.append(" The current pattern is: ");
                    sb.append(this.tagPattern);
                    sb.append(".");
                    sb.append(" Some found patterns look like: ");
                    sb.append(this.formatLastTags(repository, 3));
                    sb.append(".");
                }
                this.log(sb.toString(), 1);
                this.getProject().setInheritedProperty(this.propertyName, "not available");
            }
        }
        catch (Exception e) {
            this.log("Unable to determine git description for repo: " + this.repositoryName + ". Reason: " + e.getLocalizedMessage(), 1);
            this.getProject().setInheritedProperty(this.propertyName, "not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatLastTags(Repository repo, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Parameter count has to be positive");
        }
        HashMap<ObjectId, Ref> tags = new HashMap<ObjectId, Ref>();
        ArrayList walkedTags = new ArrayList();
        try (RevWalk revw = new RevWalk(repo);){
            for (Ref r : repo.getRefDatabase().getRefs("refs/tags/").values()) {
                ObjectId key = repo.peel(r).getPeeledObjectId();
                if (key == null) {
                    key = r.getObjectId();
                }
                tags.put(key, r);
            }
            ObjectId headId = repo.resolve("HEAD");
            RevCommit headCommit = revw.parseCommit((AnyObjectId)headId);
            revw.markStart(headCommit);
            RevCommit candidate = null;
            int added = 0;
            while ((candidate = revw.next()) != null && added < count) {
                ObjectId candidateId = candidate.getId();
                if (!tags.containsKey(candidateId)) continue;
                walkedTags.add(tags.get(candidateId));
                ++added;
            }
        }
        if (walkedTags.isEmpty()) {
            return "no tags found";
        }
        ArrayList<String> shortenedTags = new ArrayList<String>(walkedTags.size());
        for (Ref ref : walkedTags) {
            shortenedTags.add(Repository.shortenRefName((String)ref.getName()));
        }
        return shortenedTags.toString();
    }
}

