/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.build.documentation.generator.json;

import com.openexchange.build.documentation.generator.DocumentationGenerator;
import com.openexchange.build.documentation.generator.json.JSONGenerator;
import com.openexchange.build.documentation.generator.json.JSONPrepared;
import com.openexchange.build.documentation.models.Property;
import com.openexchange.build.documentation.models.YamlFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\f\u0010!\u001a\u00020\r*\u00020\rH\u0002J\u0014\u0010\"\u001a\u00020\r*\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\f\u0010#\u001a\u00020\r*\u00020\rH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/openexchange/build/documentation/generator/json/JSONGenerator;", "Lcom/openexchange/build/documentation/generator/DocumentationGenerator;", "Lcom/openexchange/build/documentation/generator/json/JSONPrepared;", "()V", "featureList", "Ljava/util/ArrayList;", "Lorg/json/simple/JSONObject;", "Lkotlin/collections/ArrayList;", "properties", "tags", "Lorg/json/simple/JSONArray;", "parseToList", "", "", "related", "", "prepareOutputData", "yamlFiles", "Lcom/openexchange/build/documentation/models/YamlFile;", "version", "chosenPackage", "sanitize", "value", "toJsonObject", "", "property", "Lcom/openexchange/build/documentation/models/Property;", "featureName", "transformSquareBracketsToATags", "write", "prepared", "destination", "Ljava/io/File;", "replaceLineBreak", "replaceVersionKeyword", "wrapATag", "Companion", "documentation-properties"})
public final class JSONGenerator
implements DocumentationGenerator<JSONPrepared> {
    private final ArrayList<JSONObject> properties = new ArrayList();
    private final ArrayList<JSONObject> featureList = new ArrayList();
    private JSONArray tags = new JSONArray();
    @NotNull
    private static HashMap<String, String> sanitizing;
    public static final Companion Companion;

    @Override
    @NotNull
    public JSONPrepared prepareOutputData(@NotNull List<YamlFile> yamlFiles, @Nullable String version, @Nullable String chosenPackage) {
        Intrinsics.checkNotNullParameter(yamlFiles, (String)"yamlFiles");
        Iterable $this$forEach$iv = yamlFiles;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            YamlFile yamlFile = (YamlFile)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = yamlFile.getProperties();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Property property = (Property)element$iv2;
                boolean bl2 = false;
                this.toJsonObject(property, yamlFile.getFeature_name());
            }
            JSONObject feature = new JSONObject();
            ((Map)feature).put("Name", yamlFile.getFeature_name());
            Map map = (Map)feature;
            String string2 = yamlFile.getFeature_description();
            if (string2 != null) {
                String string3 = version;
                Intrinsics.checkNotNull((Object)string3);
                string = this.replaceVersionKeyword(string2, string3);
            } else {
                string = null;
            }
            map.put("Description", this.transformSquareBracketsToATags(string));
            this.featureList.add(feature);
        }
        JSONArray $i$f$forEach22 = new JSONArray();
        boolean bl = false;
        boolean bl3 = false;
        JSONArray distinct = $i$f$forEach22;
        boolean bl4 = false;
        distinct.addAll((Collection)CollectionsKt.distinct((Iterable)((Iterable)this.tags)));
        JSONArray distinctTags = $i$f$forEach22;
        CollectionsKt.sortWith((List)((List)distinctTags), (Comparator)prepareOutputData.2.INSTANCE);
        List list2 = this.properties;
        List list3 = this.featureList;
        String string = version;
        Intrinsics.checkNotNull((Object)string);
        JSONPrepared prepared = new JSONPrepared(list2, list3, distinctTags, string);
        prepared.setFeaturesList(CollectionsKt.sortedWith((Iterable)prepared.getFeaturesList(), (Comparator)prepareOutputData.3.INSTANCE));
        prepared.setProperties(CollectionsKt.sortedWith((Iterable)prepared.getProperties(), (Comparator)prepareOutputData.4.INSTANCE));
        return prepared;
    }

    private final void toJsonObject(Property property, String featureName) {
        JSONObject prop = new JSONObject();
        ((Map)prop).put("Key", property.getKey());
        ((Map)prop).put("Default", this.sanitize(property.getDefaultValue()));
        String string = property.getFile();
        ((Map)prop).put("File", string != null ? this.replaceLineBreak(string) : null);
        ((Map)prop).put("Package", property.getPackageName());
        ((Map)prop).put("Description", property.getDescription());
        ((Map)prop).put("ConfigCascadeAware", property.isConfigcascadeAware());
        ((Map)prop).put("Reloadable", property.isReloadable());
        if (property.getRelated() != null) {
            ((Map)prop).put("Related", this.parseToList(property.getRelated()));
        }
        ((Map)prop).put("Version", property.getVersion());
        ((Map)prop).put("Tags", property.getTags());
        ((Map)prop).put("Feature", featureName);
        this.properties.add(prop);
        this.tags.addAll((Collection)property.getTags());
    }

    private final String replaceLineBreak(String $this$replaceLineBreak) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$replaceLineBreak, (String)"(\r\n|\n\r)", (String)"<br>", (boolean)false, (int)4, null), (String)"(\r\n\n|\n\n\r)", (String)"<br><br>", (boolean)false, (int)4, null), (String)"(\r\n\n\n|\n\n\n\r)", (String)"<br><br><br>", (boolean)false, (int)4, null);
    }

    private final String replaceVersionKeyword(String $this$replaceVersionKeyword, String version) {
        CharSequence charSequence = $this$replaceVersionKeyword;
        Regex regex = new Regex("\\{\\{version}}");
        boolean bl = false;
        return regex.replace(charSequence, version);
    }

    private final String wrapATag(String $this$wrapATag) {
        return "<a href=#" + $this$wrapATag + '>' + $this$wrapATag + "</a>";
    }

    private final String sanitize(String value) {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String result = value;
        for (String key : sanitizing.keySet()) {
            CharSequence charSequence2 = result;
            String string = key;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
            String string2 = string;
            boolean bl3 = false;
            string2 = new Regex(string2);
            String string3 = String.valueOf(sanitizing.get(key));
            boolean bl4 = false;
            result = string2.replace(charSequence2, string3);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseToList(Object related) {
        List list2;
        Object object = related;
        if (object instanceof String) {
            list2 = CollectionsKt.listOf((Object)this.wrapATag((String)related));
        } else {
            List list3 = (List)related;
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void item;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = this.wrapATag((String)item);
                    collection.add(string2);
                }
                list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else {
                list2 = null;
            }
        }
        return list2;
    }

    private final String transformSquareBracketsToATags(String value) {
        if (value == null) {
            return null;
        }
        Regex first = new Regex("\\[\\[(http.*?)]]");
        Regex second = new Regex("\\[\\[(.*?)]]");
        CharSequence charSequence = value;
        Function1 function1 = transformSquareBracketsToATags.replaced.1.INSTANCE;
        boolean bl = false;
        String replaced2 = first.replace(charSequence, function1);
        charSequence = replaced2;
        function1 = transformSquareBracketsToATags.1.INSTANCE;
        bl = false;
        replaced2 = second.replace(charSequence, function1);
        return replaced2;
    }

    @Override
    public void write(@NotNull JSONPrepared prepared, @NotNull File destination) throws IOException {
        Intrinsics.checkNotNullParameter((Object)prepared, (String)"prepared");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        File file = new File(destination, "properties.json");
        FileWriter writer = new FileWriter(file);
        JSONObject json = new JSONObject();
        ((Map)json).put("properties", prepared.getProperties());
        ((Map)json).put("features", prepared.getFeaturesList());
        ((Map)json).put("tags", prepared.getTagsSet());
        JSONObject versionJSON = new JSONObject();
        ((Map)versionJSON).put("Year", Calendar.getInstance().get(1));
        ((Map)versionJSON).put("Version", prepared.getVersion());
        ((Map)json).put("version", versionJSON);
        writer.write(json.toJSONString());
        writer.close();
    }

    static {
        Companion = new Companion(null);
        sanitizing = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"<", (Object)"&lt;"), TuplesKt.to((Object)">", (Object)"&gt;")});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/openexchange/build/documentation/generator/json/JSONGenerator$Companion;", "", "()V", "sanitizing", "Ljava/util/HashMap;", "", "getSanitizing", "()Ljava/util/HashMap;", "setSanitizing", "(Ljava/util/HashMap;)V", "documentation-properties"})
    public static final class Companion {
        @NotNull
        public final HashMap<String, String> getSanitizing() {
            return sanitizing;
        }

        public final void setSanitizing(@NotNull HashMap<String, String> hashMap) {
            Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
            sanitizing = hashMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

