/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.AddMember;
import com.dropbox.core.v2.paper.RefPaperDoc;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class AddPaperDocUser
extends RefPaperDoc {
    protected final List<AddMember> members;
    protected final String customMessage;
    protected final boolean quiet;

    public AddPaperDocUser(String docId, List<AddMember> members, String customMessage, boolean quiet) {
        super(docId);
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        if (members.size() > 20) {
            throw new IllegalArgumentException("List 'members' has more than 20 items");
        }
        for (AddMember x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.customMessage = customMessage;
        this.quiet = quiet;
    }

    public AddPaperDocUser(String docId, List<AddMember> members) {
        this(docId, members, null, false);
    }

    @Override
    public String getDocId() {
        return this.docId;
    }

    public List<AddMember> getMembers() {
        return this.members;
    }

    public String getCustomMessage() {
        return this.customMessage;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public static Builder newBuilder(String docId, List<AddMember> members) {
        return new Builder(docId, members);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.members, this.customMessage, this.quiet});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            AddPaperDocUser other = (AddPaperDocUser)obj;
            return !(this.docId != other.docId && !this.docId.equals(other.docId) || this.members != other.members && !this.members.equals(other.members) || this.customMessage != other.customMessage && (this.customMessage == null || !this.customMessage.equals(other.customMessage)) || this.quiet != other.quiet);
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AddPaperDocUser> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AddPaperDocUser value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("doc_id");
            StoneSerializers.string().serialize(value.docId, g);
            g.writeFieldName("members");
            StoneSerializers.list(AddMember.Serializer.INSTANCE).serialize(value.members, g);
            if (value.customMessage != null) {
                g.writeFieldName("custom_message");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.customMessage, g);
            }
            g.writeFieldName("quiet");
            StoneSerializers.boolean_().serialize((Boolean)value.quiet, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public AddPaperDocUser deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_quiet;
            String f_customMessage;
            List<AddMember> f_members;
            String f_docId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docId = null;
                f_members = null;
                f_customMessage = null;
                f_quiet = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_id".equals(field)) {
                        f_docId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(AddMember.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("custom_message".equals(field)) {
                        f_customMessage = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("quiet".equals(field)) {
                        f_quiet = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docId == null) {
                    throw new JsonParseException(p, "Required field \"doc_id\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AddPaperDocUser value = new AddPaperDocUser(f_docId, f_members, f_customMessage, f_quiet);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String docId;
        protected final List<AddMember> members;
        protected String customMessage;
        protected boolean quiet;

        protected Builder(String docId, List<AddMember> members) {
            if (docId == null) {
                throw new IllegalArgumentException("Required value for 'docId' is null");
            }
            this.docId = docId;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            if (members.size() > 20) {
                throw new IllegalArgumentException("List 'members' has more than 20 items");
            }
            for (AddMember x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            this.customMessage = null;
            this.quiet = false;
        }

        public Builder withCustomMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public Builder withQuiet(Boolean quiet) {
            this.quiet = quiet != null ? quiet : false;
            return this;
        }

        public AddPaperDocUser build() {
            return new AddPaperDocUser(this.docId, this.members, this.customMessage, this.quiet);
        }
    }
}

