/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.worker.handler;

import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/osgi/worker/handler/TargetPlatformHandler;", "Lcom/openexchange/osgi/worker/handler/ProjectHandler;", "()V", "handle", "", "project", "Lorg/gradle/api/Project;", "osgi"})
public final class TargetPlatformHandler
implements ProjectHandler {
    @Override
    public void handle(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Logger logger = project.getLogger();
        logger.info("OSGi-Plugin: Found target platform: {}", (Object)project.getName());
        File jarsDir = new File(project.getProjectDir(), "jars");
        File[] jars = jarsDir.listFiles();
        if (jars == null) {
            logger.debug("No JARs found for project {} in path {}", (Object)project.getName(), (Object)jarsDir.getAbsolutePath());
            return;
        }
        project.getConfigurations().maybeCreate("archives");
        for (File file : jars) {
            logger.info("Adding JAR {} for project {}", (Object)file, (Object)project.getName());
            project.getArtifacts().add("archives", (Object)file);
        }
        try {
            OSGiPlugin.Companion.getModuleDatabase().addBinaryModules(Arrays.copyOf(jars, jars.length));
        }
        catch (IOException e) {
            throw (Throwable)new GradleException("Unable to add JARS to the module database: " + e.getMessage(), (Throwable)e);
        }
    }
}

