/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.gradle.plugin;

import com.openexchange.obs.gradle.plugin.Repository;
import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;

public class Project {
    private String name;
    private final NamedDomainObjectContainer<Repository> repositoryContainer;
    private static final String DEFAULT_CONFIGURATION = "Macros:\n%vendor Open-Xchange\n";

    @Inject
    public Project(org.gradle.api.Project project) {
        this.repositoryContainer = project.container(Repository.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<Repository>(){

            public Repository create(String name) {
                return new Repository(name);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public void repositories(Closure<?> closure) {
        this.repositoryContainer.configure(closure);
    }

    public void repositories(Action<? super NamedDomainObjectContainer<Repository>> action) {
        action.execute(this.repositoryContainer);
    }

    public com.openexchange.obs.api.Project convert(String user) {
        assert (null != this.name);
        com.openexchange.obs.api.Project project = new com.openexchange.obs.api.Project(this.name, this.name, user);
        for (Repository repository : this.repositoryContainer) {
            project.addRepository(repository.convert());
        }
        project.setBuildConfiguration("Prefer: java-1.7.0-openjdk-devel\nMacros:\n%vendor Open-Xchange\n");
        return project;
    }
}

