/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.operations.LockOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AbstractLockRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected Data key;
    private long threadId;
    private long ttl = -1L;
    private long timeout = -1L;

    public AbstractLockRequest() {
    }

    public AbstractLockRequest(Data key, long threadId) {
        this.key = key;
        this.threadId = threadId;
    }

    public AbstractLockRequest(Data key, long threadId, long ttl, long timeout) {
        this.key = key;
        this.threadId = threadId;
        this.ttl = ttl;
        this.timeout = timeout;
    }

    protected String getName() {
        return (String)this.getClientEngine().toObject(this.key);
    }

    @Override
    protected final Operation prepareOperation() {
        return new LockOperation(this.getNamespace(), this.key, this.threadId, this.ttl, this.timeout);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    protected abstract ObjectNamespace getNamespace();

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("tid", this.threadId);
        writer.writeLong("ttl", this.ttl);
        writer.writeLong("timeout", this.timeout);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("tid");
        this.ttl = reader.readLong("ttl");
        this.timeout = reader.readLong("timeout");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
    }
}

