/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.extras.codecs.jdk8.IgnoreJDK6Requirement;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;

@IgnoreJDK6Requirement
public class InstantCodec
extends TypeCodec<Instant> {
    public static final InstantCodec instance = new InstantCodec();
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalEnd().optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendZoneId().optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx").withZone(ZoneOffset.UTC);

    private InstantCodec() {
        super(DataType.timestamp(), Instant.class);
    }

    public ByteBuffer serialize(Instant value, ProtocolVersion protocolVersion) {
        return value == null ? null : InstantCodec.bigint().serializeNoBoxing(value.toEpochMilli(), protocolVersion);
    }

    public Instant deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        return bytes == null || bytes.remaining() == 0 ? null : Instant.ofEpochMilli(InstantCodec.bigint().deserializeNoBoxing(bytes, protocolVersion));
    }

    public String format(Instant value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote((String)FORMATTER.format(value));
    }

    public Instant parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted((String)value)) {
            value = ParseUtils.unquote((String)value);
        }
        if (ParseUtils.isLongLiteral((String)value)) {
            try {
                return Instant.ofEpochMilli(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }
        try {
            return Instant.from(PARSER.parse(value));
        }
        catch (DateTimeParseException e) {
            throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
        }
    }
}

