/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.user;

import com.openexchange.realtime.packet.ID;

/**
 * Property class to store user-specific data regarding a connection instance.
 * Due to sharing it's now mandatory to store user-specific data and use it
 * for certain requests. Especially the document load/save processing must be
 * done using the user-specific folder & file-ids.
 *
 * @author Carsten Driesner
 * @since 7.8.0
 */
public class UserData {
    private final String folder_id;
    private final String file_id;
    private final String oldRTId;
    private final String session;
    private final String userRTId;
    private final boolean fastEmpty;
    private final String encryptionInfo;
    private final String localStorageVersion;
    private final int localStorageOSN;

    /**
     * Initialize a new UserData instance.
     *
     * @param folder_id
     * @param file_id
     * @param oldRTId
     * @param session
     */
    public UserData(final String folder_id, final String file_id, final String oldRTId, final String session, final ID userRTId, boolean fastEmpty, String cryptInfo) {
        this.folder_id = folder_id;
        this.file_id = file_id;
        this.oldRTId = oldRTId;
        this.session = session;
        this.userRTId = userRTId.toString();
        this.fastEmpty = fastEmpty;
        this.encryptionInfo = cryptInfo;
        this.localStorageVersion = null;
        this.localStorageOSN = -1;
    }

    public UserData(final String folder_id, final String file_id, final String oldRTId, final String session, final ID userRTId, boolean fastEmpty, String cryptInfo, String localStorageVersion, int localStorageOSN) {
        this.folder_id = folder_id;
        this.file_id = file_id;
        this.oldRTId = oldRTId;
        this.session = session;
        this.userRTId = userRTId.toString();
        this.fastEmpty = fastEmpty;
        this.encryptionInfo = cryptInfo;
        this.localStorageVersion = localStorageVersion;
        this.localStorageOSN = localStorageOSN;
    }

    /**
     * Retrieves the folder id of the document for this user.
     *
     * @return
     */
    public final String getFolderId() { return folder_id; }

    /**
     * Retrieves the file id of the document for this user.
     *
     * @return
     */
    public final String getFileId() { return file_id; }

    /**
     * Retrieves the Guard auth code of the document for this user.
     *
     * @return
     */
    public final String getEncryptionInfo() { return encryptionInfo; }

    /**
     * Retrieves the old real-time id of the user.
     *
     * @return
     */
    public final String getOldRTId() { return oldRTId; }

    /**
     * Retrieves the session id of the user,
     *
     * @return
     */
    public final String getSessionId() { return session; }

    public final String getUserRTId() { return userRTId; }

    public boolean getFastEmptyState() { return fastEmpty; }

    public String getLocalStorageVersion() { return localStorageVersion; }

    public int getLocalStorageOSN() { return localStorageOSN; }
}
