/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.templatemgr;

import com.openexchange.office.templatemgr.api.IResourceEntry;

/**
 * {@link ResourceEntry}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class ResourceEntry implements IResourceEntry {
    
    private String m_module = null;
    private String m_group = null;
    private String m_location = null;
    private String m_title = null;
    private String m_description = null;
    
    /**
     * Initializes a new {@link ResourceEntry}.
     * @param module
     * @param group
     * @param location
     */
    public ResourceEntry(String module, String group, String location) {
        init(module, group, location, null, null);
    }

    /**
     * Initializes a new {@link ResourceEntry}.
     * @param module
     * @param group
     * @param location
     * @param title
     */
    public ResourceEntry(String module, String group, String location, String title) {
        init(module, group, location, title, null);
    }

    /**
     * Initializes a new {@link ResourceEntry}.
     * @param module
     * @param group
     * @param location
     * @param title
     * @param description
     */
    public ResourceEntry(String module, String group, String location, String title, String description) {
        init(module, group, location, title, description);
    }
    
    /**
     * @param _module
     * @param _group
     * @param _location
     * @param _title
     * @param _description
     */
    protected void init(String _module, String _group, String _location, String _title, String _description) {
        m_module = _module;
        m_group = _group;
        m_location = _location;
        m_title = _title;
        m_description = _description;
    }

    @Override
    public String getModule() {
        return m_module;
    }

    
    @Override
    public void setModule(String module) {
        m_module = module;
    }

    
    @Override
    public String getGroup() {
        return m_group;
    }

    
    @Override
    public void setGroup(String group) {
        m_group = group;
    }

    @Override
    public String getLocation() {
        return m_location;
    }

    
    @Override
    public void setLocation(String location) {
        m_location = location;
    }

    @Override
    public String getTitle() {
        return m_title;
    }

    @Override
    public void setTitle(String title) {
        m_title = title;
    }

    @Override
    public String getDescription() {
        return m_description;
    }

    @Override
    public void setDescription(String description) {
        m_description = description;
    }
}
