/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.rest.tools;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.office.tools.files.FileHelper;
import com.openexchange.office.tools.rest.RequestDataHelper;
import com.openexchange.office.tools.session.SessionUtils;
import com.openexchange.tools.session.ServerSession;

public class RTRequestParamValidator {

    // ---------------------------------------------------------------
    @SuppressWarnings("deprecation")
    static protected final org.apache.commons.logging.Log LOG = com.openexchange.log.LogFactory.getLog(RTRequestParamValidator.class);

    // ---------------------------------------------------------------
    public static boolean areAllParamsNonEmpty(final RequestDataHelper aRequestDataHelper, String[] paramNames) {

        return (aRequestDataHelper != null) &&
            Arrays.asList(paramNames)
                  .stream()
                  .map(p -> aRequestDataHelper.getParameter(p))
                  .filter(StringUtils::isEmpty)
                  .collect(Collectors.toSet())
                  .isEmpty();
    }

    // ---------------------------------------------------------------
    public static boolean canReadFile(final ServerSession aSession, String folderId, String fileId) {
        boolean canRead = false;
        try {
            final int userId = SessionUtils.getUserId(aSession);

            // check document access rights to ensure that the current user has access rights to retrieve document content
            canRead = FileHelper.canReadFile(aSession, folderId, fileId, userId);
        } catch (Exception e) {
            LOG.error("AjaxRequest GetFileAction exception caught while trying to check access rights", e);
        }

        return canRead;
    }

    // ---------------------------------------------------------------
    public static AJAXRequestResult getResultFor(int nHttpError) {
        final AJAXRequestResult result = new AJAXRequestResult();
        result.setHttpStatusCode(nHttpError);
        return result;
    }
}
