package com.openexchange.office.rest;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.json.JSONObject;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.office.tools.session.SessionUtils;
import com.openexchange.office.tools.error.ErrorCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;


public class GetUserInfoAction extends DocumentRESTAction {
    @SuppressWarnings("deprecation")
    private static final Log LOG = com.openexchange.log.Log.loggerFor(GetUserInfoAction.class);

    /**
     * {@link GetUserInfoAction}
     *
     * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
     */

    // @Action(method = RequestMethod.GET, name = "gettemplatelist", description = "Request to receive a list of possible template files.", parameters = {
    //    @Parameter(name = "session", description = "A session ID previously obtained from the login module."),
    //    @Parameter(name = "uid", description = "The unique id of the client application."),
    //    @Parameter(name = "userId", description = "The unique id of the user where user data should be retrieved.")
    // }, responseDescription = "Response with timestamp: A JSON object containing the user data and error information.")

    /**
     * Initializes a new {@link GetTemplateListAction}.
     * @param services
     */
    public GetUserInfoAction(ServiceLookup servicesDEPRECATED) {
        super(null);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        final JSONObject jsonObj = new JSONObject();
        AJAXRequestResult requestResult = null;

        if ((null != requestData) && (null != session)) {
            ErrorCode errorCode = ErrorCode.NO_ERROR;

            try {
                final String userIdParam = requestData.getParameter("userId");
                if (null != userIdParam) {
                    int userId = Integer.parseInt(userIdParam);
                    User userData = SessionUtils.getUserInfo(session, userId, null);
                    JSONObject userDataAsJSON = GetUserInfoAction.getUserDataAsJSON(userData);
                    jsonObj.put("userData", userDataAsJSON);
                } else {
                    errorCode = ErrorCode.NO_ERROR;
                }
            } catch (Exception e) {
                LOG.error("Exception while creating retrieving user data", e);
                errorCode = ErrorCode.GETUSERINFO_UNKNOWN_ERROR;
            } finally {
                try {
                    jsonObj.put("error", errorCode.getAsJSON());
                } catch (Exception e) {
                    LOG.error("Exception while creating json object with error data", e);
                }
            }
        }

        requestResult = new AJAXRequestResult(jsonObj);

        return requestResult;
    }

    private static final JSONObject getUserDataAsJSON(User userData) throws Exception {
        final JSONObject jsonObj = new JSONObject();

        if (null != userData) {
            jsonObj.put("displayName", userData.getDisplayName());
            jsonObj.put("givenName", userData.getGivenName());
            jsonObj.put("surName", userData.getSurname());
            jsonObj.put("preferredLanguage", userData.getPreferredLanguage());
            jsonObj.put("timeZone", userData.getTimeZone());

            Locale locale = userData.getLocale();
            if (null != locale) {
                final JSONObject localeData = new JSONObject();
                localeData.put("language", locale.getLanguage());
                localeData.put("country", locale.getCountry());
                jsonObj.put("locale", localeData);
            }
        }

        return jsonObj;
    }
}
