/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.rest.osgi;

import java.util.List;

import org.slf4j.Logger;

import com.openexchange.config.ConfigurationService;
import com.openexchange.context.ContextService;
import com.openexchange.documentconverter.IDocumentConverter;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.imagetransformation.ImageMetadataService;
import com.openexchange.jslob.JSlobService;
import com.openexchange.office.backup.manager.DocumentBackupController;
import com.openexchange.office.rest.DocumentRESTActionFactory;
import com.openexchange.office.templatemgr.api.IResourceProvider;
import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.office.tools.osgi.ActivatorBase;
import com.openexchange.preview.PreviewService;
import com.openexchange.realtime.dispatch.MessageDispatcher;
import com.openexchange.timer.TimerService;
import com.openexchange.user.UserService;
import com.openexchange.net.ssl.SSLSocketFactoryProvider;
import com.openexchange.net.ssl.config.SSLConfigurationService;

//=============================================================================
public class RESTActivator extends ActivatorBase
{
	//-------------------------------------------------------------------------
	private static final String AJAX_MODULE_ID = "oxodocumentfilter";

	//-------------------------------------------------------------------------
    private static final String SERVICE_NAME = "com.openexchange.office.rest";

	//-------------------------------------------------------------------------
    private static final Logger LOG = LogFactory.getSlfLog(RESTActivator.class);

	//-------------------------------------------------------------------------
    public RESTActivator()
    	throws Exception
    {
        super(SERVICE_NAME);
    }

    //-------------------------------------------------------------------------
    @Override
    protected void listMandatoryServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
        lServices.add (com.openexchange.office.filter.ods.dom.Importer                     .class);
        lServices.add (com.openexchange.office.filter.odt.dom.Importer                     .class);
        lServices.add (com.openexchange.office.filter.odp.dom.Importer                     .class);
        lServices.add (com.openexchange.office.filter.odf.       Exporter                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.pptx.Importer                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.pptx.Exporter                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.docx.Importer                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.docx.Exporter                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.xlsx.Importer                  .class);
        lServices.add (com.openexchange.office.filter.ooxml.xlsx.Exporter                  .class);
        lServices.add (                                          IDBasedFileAccessFactory  .class);
        lServices.add (                                          IDBasedFolderAccessFactory.class);
        lServices.add (                                          IResourceProvider         .class);
        lServices.add (                                          ConfigurationService      .class);
        lServices.add (                                          JSlobService              .class);
        lServices.add (                                          UserService               .class);
        lServices.add (                                          ContextService            .class);
        lServices.add (                                          DocumentBackupController  .class);
        lServices.add (                                          TimerService              .class);
        lServices.add (                                          ManagedFileManagement     .class);
        lServices.add (com.openexchange.net.ssl.SSLSocketFactoryProvider                   .class);
        lServices.add (com.openexchange.net.ssl.config.SSLConfigurationService             .class);
        lServices.add (ImageMetadataService                                                .class);
    }

    //-------------------------------------------------------------------------
    @Override
    protected void listOptionalServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	lServices.add (DistributedFileManagement.class);
    	lServices.add (FolderService            .class);
    	lServices.add (IDocumentConverter       .class);
    	lServices.add (MessageDispatcher        .class);
    	lServices.add (PreviewService           .class);
    }

    //-------------------------------------------------------------------------
    @Override
    protected void activate()
    	throws Exception
    {
        m_aAJAXModule = new DocumentRESTActionFactory(null);
        registerAJAXModule(m_aAJAXModule, AJAX_MODULE_ID, true);
    }

    //-------------------------------------------------------------------------
    @Override
    protected void deactivate()
    	throws Exception
    {
        final DocumentRESTActionFactory aAJAXModule = m_aAJAXModule;
        if (null != aAJAXModule) {
            aAJAXModule.shutdown();
        }

    	// de-registration of services is done by base class ...
    	// further actions not needed
    }

	//-------------------------------------------------------------------------
    private DocumentRESTActionFactory m_aAJAXModule = null;
}
