/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.operations;

import org.docx4j.dml.BaseStyles.FontScheme;
import java.util.Set;
import org.docx4j.dml.CTColorMapping;
import org.docx4j.dml.CTColorScheme;
import org.docx4j.dml.FontCollection;
import org.docx4j.dml.Theme;
import org.docx4j.openpackaging.parts.ThemePart;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.api.OCValue;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.tools.Commons;
import com.openexchange.office.filter.ooxml.tools.ThemeFonts;

abstract public class CreateOperationHelper {

    protected final OperationDocument operationDocument;
    protected JSONArray operationsArray;
    protected int jsonLogSize;

    protected CreateOperationHelper(OperationDocument _operationDocument, JSONArray _operationsArray)
    	throws FilterException {

    	operationDocument = _operationDocument;
        operationsArray = _operationsArray;
        jsonLogSize = 0;
    }

    abstract public OperationDocument getOperationDocument();

    private void putSchemeColor(final JSONObject jsonColorScheme, final String colorKey, final CTColorScheme colorScheme, final CTColorMapping colorMapping)
        throws JSONException {
        jsonColorScheme.put(colorKey, Commons.ctColorToString(colorScheme.getByColorKey(colorKey, colorMapping)));
    }

    private void putSchemeFont(final JSONObject jsonFontScheme, final String fontKey, final FontCollection schemeFont)
        throws JSONException {
        if (schemeFont != null) { jsonFontScheme.put(fontKey, schemeFont.getLatin().getTypeface()); }
    }

    public void createThemeOperations(String target, JSONArray start, CTColorMapping colorMapping)
        throws FilterException, JSONException {

        final ThemePart themePart = getOperationDocument().getThemePart(true);
    	final Theme theme = themePart.getJaxbElement();

        final CTColorScheme colorScheme = theme.getThemeElements().getClrScheme();
        final JSONObject jsonColorScheme = new JSONObject();
        putSchemeColor(jsonColorScheme, "dark1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "dark2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "light1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "light2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "text1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "text2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "background1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "background2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent1", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent2", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent3", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent4", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent5", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "accent6", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "hyperlink", colorScheme, colorMapping);
        putSchemeColor(jsonColorScheme, "followedHyperlink", colorScheme, colorMapping);

        final FontScheme fontScheme = theme.getThemeElements().getFontScheme();
        final JSONObject jsonFontScheme = new JSONObject(2);
        putSchemeFont(jsonFontScheme, ThemeFonts.MAJOR_ID, fontScheme.getMajorFont());
        putSchemeFont(jsonFontScheme, ThemeFonts.MINOR_ID, fontScheme.getMinorFont());

        addInsertThemeOperation(themePart.getPartName().getName(), jsonColorScheme, jsonFontScheme, target, start);
    }

    public JSONArray getOperationsArray() {
    	return operationsArray;
    }

    public void setOperationsArray(JSONArray _operationsArray) {
    	operationsArray = _operationsArray;
    }

    public void addInsertThemeOperation(String themeName, JSONObject clrScheme, JSONObject fontScheme, String target, JSONArray start)
        throws JSONException {

        final JSONObject insertThemeObject = new JSONObject(5);
        insertThemeObject.put(OCKey.NAME.value(), OCValue.INSERT_THEME.value());
        insertThemeObject.put(OCKey.THEME_NAME.value(), themeName);
        insertThemeObject.put(OCKey.COLOR_SCHEME.value(), clrScheme);
        insertThemeObject.put(OCKey.FONT_SCHEME.value(), fontScheme);
        if(target!=null) {
        	insertThemeObject.put(OCKey.TARGET.value(), target);
        }
        if(start!=null) {
            insertThemeObject.put(OCKey.START.value(), start);
        }
        operationsArray.put(insertThemeObject);
    }

    public JSONObject createInsertStyleSheetOperation(String type, boolean isDefaultType, String styleId, String styleName, JSONObject attrs, String parentId, Boolean hidden, Integer uipriority, Boolean isDefault, Boolean custom)
        throws JSONException {

        final JSONObject insertStylesheetObject = new JSONObject(10);
        insertStylesheetObject.put(OCKey.NAME.value(), OCValue.INSERT_STYLE_SHEET.value());
        if(!isDefaultType) {
            insertStylesheetObject.put(OCKey.TYPE.value(), type);
        }
        insertStylesheetObject.put(OCKey.STYLE_ID.value(), styleId);
        insertStylesheetObject.put(OCKey.STYLE_NAME.value(), styleName);
        if(attrs!=null)
            insertStylesheetObject.put(OCKey.ATTRS.value(), attrs);
        if(parentId!=null&&parentId.length()>0)
            insertStylesheetObject.put(OCKey.PARENT.value(), parentId);
        if(hidden!=null)
            insertStylesheetObject.put(OCKey.HIDDEN.value(), hidden);
        if(uipriority!=null)
            insertStylesheetObject.put(OCKey.UI_PRIORITY.value(), uipriority);
        if(isDefault!=null&&isDefault)
            insertStylesheetObject.put(OCKey.DEFAULT.value(), true);
        if(custom!=null) {
            insertStylesheetObject.put(OCKey.CUSTOM.value(), custom);
        }
        return insertStylesheetObject;
    }

    public JSONObject createInsertAutoStyleOperation(String styleId, JSONObject attrs, boolean isDefault)
        throws JSONException {

        final JSONObject insertStylesheetObject = new JSONObject(5);
        insertStylesheetObject.put(OCKey.NAME.value(), OCValue.INSERT_AUTO_STYLE.value());
        insertStylesheetObject.put(OCKey.STYLE_ID.value(), styleId);
        if(attrs!=null)
            insertStylesheetObject.put(OCKey.ATTRS.value(), attrs);
        if(isDefault)
            insertStylesheetObject.put(OCKey.DEFAULT.value(), true);
        return insertStylesheetObject;
    }

    public JSONObject addSetDocumentAttributesOperation()
        throws JSONException {

        final JSONObject documentAttributes = new JSONObject();
        final JSONObject setDocumentAttributesObject = new JSONObject(2);
        setDocumentAttributesObject.put(OCKey.NAME.value(), OCValue.SET_DOCUMENT_ATTRIBUTES.value());
        setDocumentAttributesObject.put(OCKey.ATTRS.value(), documentAttributes);
        operationsArray.put(setDocumentAttributesObject);
        return documentAttributes;
    }

    // usedLanguages are only available after creating operations for the whole document (via _createOperations)
    public void createUsedLanguages(JSONObject documentAttributes) throws JSONException {
        applyLanguages(documentAttributes, OCKey.USED_LANGUAGES, getOperationDocument().getUsedLanguages());
        applyLanguages(documentAttributes, OCKey.USED_LANGUAGES_EA, getOperationDocument().getUsedLanguagesEA());
        applyLanguages(documentAttributes, OCKey.USED_LANGUAGES_BIDI, getOperationDocument().getUsedLanguagesBidi());
    }

    private void applyLanguages(JSONObject documentAttributes, OCKey attributeName, Set<String> usedLanguages) throws JSONException {
        if(!usedLanguages.isEmpty()) {
            JSONObject jsonDocumentSettings = documentAttributes.optJSONObject(OCKey.DOCUMENT.value());
            if(jsonDocumentSettings==null) {
                documentAttributes.put(OCKey.DOCUMENT.value(), jsonDocumentSettings = new JSONObject());
            }
            jsonDocumentSettings.put(attributeName.value(), new JSONArray(usedLanguages));
        }
    }
}
