/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx.tools;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.CTAutoFilter;
import org.xlsx4j.sml.CTSortState;
import org.xlsx4j.sml.SmlUtils;
import org.xlsx4j.sml.SmlUtils.CellRef;
import org.xlsx4j.sml.SmlUtils.CellRefRange;
import org.xlsx4j.sml.Worksheet;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.api.OCValue;
import com.openexchange.office.filter.ooxml.xlsx.operations.XlsxApplyOperationHelper;

public class AutoFilterHelper {

    enum FilterType {
        NONE,
        DISCRETE
    };

    public static void createAutoFilterOperations(JSONArray operationsArray, int sheetIndex, CTAutoFilter autoFilter)
        throws JSONException {

        if(autoFilter==null) {
            return;
        }
        CTSortState sortState = autoFilter.getSortState(false);
        final SmlUtils.CellRefRange cellRefRange = autoFilter.getCellRefRange(false);
        if(cellRefRange==null) {
            return;
        }
        JSONObject attrs = new JSONObject(1);
        final JSONObject tableAttrs = new JSONObject(1);
        tableAttrs.put(OCKey.HEADER_ROW.value(), true);
        if(sortState!=null&&sortState.isCaseSensitive()) {
            tableAttrs.put(OCKey.CASE_SENSITIVE.value(), true);
        }
        attrs.put(OCKey.TABLE.value(), tableAttrs);
        addInsertTableOperation(operationsArray, sheetIndex, cellRefRange, "", attrs);
        TableHelper.createChangeTableColumnOperations(operationsArray, sheetIndex, "", cellRefRange.getStart().getColumn(), autoFilter, sortState);
    }

    public static void addInsertTableOperation(JSONArray operationsArray, int sheetIndex, SmlUtils.CellRefRange range, String tableName, JSONObject attrs)
            throws JSONException {

        final JSONObject addInsertTableObject = new JSONObject(6);
        addInsertTableObject.put(OCKey.NAME.value(), OCValue.INSERT_TABLE.value());
        addInsertTableObject.put(OCKey.SHEET.value(), sheetIndex);
        addInsertTableObject.put(OCKey.START.value(), range.getStart().getJSONArray());
        addInsertTableObject.put(OCKey.END.value(), range.getEnd().getJSONArray());
        if(!attrs.isEmpty()) {
            addInsertTableObject.put(OCKey.ATTRS.value(), attrs);
        }
        if(tableName!=null && tableName.length()>0) {
            addInsertTableObject.put(OCKey.TABLE.value(), tableName);
        }
        operationsArray.put(addInsertTableObject);
    }

    public static void changeOrInsertAutoFilter(XlsxApplyOperationHelper applyOperationHelper, int sheetIndex, JSONArray start, JSONArray end, JSONObject attrs)
        throws JSONException {

        final Worksheet worksheet = (Worksheet)applyOperationHelper.getWorksheet(sheetIndex);
        final CTAutoFilter autoFilter = worksheet.getAutoFilter(true);
        final CellRefRange cellRefRange = autoFilter.getCellRefRange(true);
        if(start!=null) {
            final CellRef startRef = cellRefRange.getStart();
            startRef.setColumn(start.getInt(0));
            startRef.setRow(start.getInt(1));
            final CellRef endRef = cellRefRange.getEnd();
            if(end==null) {
                endRef.setColumn(start.getInt(0));
                endRef.setRow(start.getInt(1));
        	}
        	else {
                endRef.setColumn(end.getInt(0));
                endRef.setRow(end.getInt(1));
        	}
        }
        if(attrs!=null) {
            applyTableAttributes(autoFilter, attrs);
        }
    }

    public static void deleteAutoFilter(XlsxApplyOperationHelper applyOperationHelper, int sheetIndex) {

        final Worksheet worksheet = (Worksheet)applyOperationHelper.getWorksheet(sheetIndex);
        worksheet.setAutoFilter(null);
    }

    private static void applyTableAttributes(CTAutoFilter autoFilter, JSONObject attrs) {
        final JSONObject tableAttrs = attrs.optJSONObject(OCKey.TABLE.value());
        if(tableAttrs!=null) {
            final Object caseSensitive = tableAttrs.opt(OCKey.CASE_SENSITIVE.value());
            if(caseSensitive instanceof Boolean&&((Boolean)caseSensitive).booleanValue()) {
                autoFilter.getSortState(true).setCaseSensitive(Boolean.TRUE);
            }
            else {
                final CTSortState sortState = autoFilter.getSortState(false);
                if(sortState!=null) {
                    sortState.setCaseSensitive(null);
                }
            }
        }

    }
}
