/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.pptx.components;

import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.SerializationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.json.JSONObject;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.IContentAccessor;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.component.Child;
import com.openexchange.office.filter.core.component.ComponentContext;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.Component;
import com.openexchange.office.filter.ooxml.pptx.PptxOperationDocument;
import com.openexchange.office.filter.ooxml.pptx.operations.PptxApplyOperationHelper;

public class RootComponent extends PptxComponent {

	public RootComponent(PptxApplyOperationHelper operationHelper, String target) {
		super(operationHelper.getOperationDocument(), new DLNode<Object>(operationHelper.setContextPartByTarget(target)), 0);
        final IContentAccessor contentAccessor = (IContentAccessor)operationDocument.getContextPart();
        if((contentAccessor instanceof SlideMasterPart) || (contentAccessor instanceof SlideLayoutPart)) {
        	// adding dummy content as the first json address is always 0 and to be ignored
        	this.setNode(new DLNode<Object>(new DummyContentAccessor(contentAccessor)));
        }
    }

	public RootComponent(PptxOperationDocument operationDocument, SerializationPart<?> targetPart) {
	    super(operationDocument, new DLNode<Object>(operationDocument.setContextPart(targetPart)), 0);
        final IContentAccessor contentAccessor = (IContentAccessor)operationDocument.getContextPart();
        if((contentAccessor instanceof SlideMasterPart) || (contentAccessor instanceof SlideLayoutPart)) {
            // adding dummy content as the first json address is always 0 and to be ignored
            this.setNode(new DLNode<Object>(new DummyContentAccessor(contentAccessor)));
        }
	}

	private class DummyContentAccessor implements IContentAccessor {

    	final DLList<Object> content;

    	public DummyContentAccessor(IContentAccessor c) {
    		content = new DLList<Object>();
    		content.add(c);
    	}
		@Override
		public DLList<Object> getContent() {
			return content;
		}
    }

    @Override
    public Component getNextComponent() {
        return null;
    }
    @Override
    public Component getNextChildComponent(ComponentContext<OperationDocument, Component> previousChildContext, Component previousChildComponent) {
        final DLNode<Object> rootNode = getNode();
        final DLList<Object> nodeList = (DLList<Object>)((IContentAccessor)rootNode.getData()).getContent();
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        DLNode<Object> childNode = previousChildContext!=null ? previousChildContext.getNode().getNext() : nodeList.getFirstNode();

        Component nextComponent = null;
        for(; nextComponent==null&&childNode!=null; childNode = childNode.getNext()) {
            final Object o = getContentModel(childNode, rootNode.getData());
            if(o instanceof SlidePart) {
            	operationDocument.setContextPart((SlidePart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof SlideMasterPart) {
            	operationDocument.setContextPart((SlideMasterPart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
            else if(o instanceof SlideLayoutPart) {
            	operationDocument.setContextPart((SlideLayoutPart)o);
            	nextComponent = new SlideComponent(this, childNode, nextComponentNumber);
            }
        }
        return nextComponent;
    }
    @Override
    public Component insertChildComponent(ComponentContext<OperationDocument, Component> parentContext, DLNode<Object> contextNode, int number, Component child, Type type) {

        DLList<Object> DLList;
        DLNode<Object> referenceNode = null;
        if(child!=null&&child.getComponentNumber()==number) {
            final ComponentContext<OperationDocument, Component> contextChild = child.getContextChild(null);
            DLList = (DLList<Object>)((IContentAccessor)contextChild.getParentContext().getNode().getData()).getContent();
            referenceNode = contextChild.getNode();
        }
        else {
            DLList = (DLList<Object>)((IContentAccessor)contextNode.getData()).getContent();
        }

        switch(type) {
            case PARAGRAPH : {
                final Child newChild = Context.getDmlObjectFactory().createCTTextParagraph();
                newChild.setParent(contextNode.getData());
                final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
                DLList.addNode(referenceNode, newChildNode, true);
                return new ParagraphComponent(parentContext, newChildNode, number);
            }
            default : {
                throw new UnsupportedOperationException();
            }
        }
    }
    @Override
    public void applyAttrsFromJSON(JSONObject attrs) {
        //
    }
    @Override
    public JSONObject createJSONAttrs(JSONObject attrs) {
        return attrs;
    }
}
