/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTFFCheckBox;
import org.docx4j.wml.CTFFDDList;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFTextInput;
import org.docx4j.wml.DelInstrText;
import org.docx4j.wml.InstrText;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.component.ComponentContext;
import com.openexchange.office.filter.ooxml.OperationDocument;
import com.openexchange.office.filter.ooxml.components.Component;

public class FldCharBegin extends FldChar_Base {

    private List<DLNode<Object>> instructionNodes = new ArrayList<DLNode<Object>>();

    public FldCharBegin(ComponentContext<OperationDocument, Component> parentContext, DLNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

    @Override
    public void applyAttrsFromJSON(JSONObject attrs)
            throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

        final JSONObject characterAttrs = attrs.optJSONObject(OCKey.CHARACTER.value());
        if(characterAttrs!=null) {
            final JSONObject fieldAttrs = characterAttrs.optJSONObject(OCKey.FIELD.value());
            if(fieldAttrs!=null) {
                final Object formFieldType = fieldAttrs.opt(OCKey.FORM_FIELD_TYPE.value());
                if(formFieldType!=null) {
                    if(formFieldType instanceof String) {
                        if(formFieldType.equals("checkBox")) {
                            final CTFFData ctFFData = new CTFFData();
                            fldChar.setFfData(ctFFData);
                            final CTFFCheckBox checkBox = new CTFFCheckBox();
                            final Object checked = fieldAttrs.opt(OCKey.CHECKED.value());
                            if(checked instanceof Boolean) {
                                checkBox.setChecked(new BooleanDefaultTrue((Boolean)checked));
                            }
                            ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataCheckBox(checkBox));
                        }
                        else if(formFieldType.equals("textInput")) {
                            final CTFFData ctFFData = new CTFFData();
                            fldChar.setFfData(ctFFData);
                            final CTFFTextInput textInput = new CTFFTextInput();
                            ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataTextInput(textInput));
                        }
                        else if(formFieldType.equals("dropDownList")) {
                            final CTFFData ctFFData = new CTFFData();
                            fldChar.setFfData(ctFFData);
                            final CTFFDDList ddList = new CTFFDDList();
                            ctFFData.getNameOrEnabledOrCalcOnExit().add(Context.getWmlObjectFactory().createCTFFDataDdList(ddList));
                        }
                    }
                    else {
                        fldChar.setFfData(null);
                    }
                }
            }
        }
        super.applyAttrsFromJSON(attrs);
    }

    public List<DLNode<Object>> getInstructionNodes() {
        return instructionNodes;
    }

    public String getInstruction() {
        final StringBuffer stringBuffer = new StringBuffer();
        for(DLNode<Object> node:instructionNodes) {
            if(stringBuffer.length()>0) {
                stringBuffer.append(' ');
            }
            final Object o = node.getData();
            if(o instanceof InstrText) {
                stringBuffer.append(((InstrText)o).getValue());
            }
            else if(o instanceof DelInstrText) {
                stringBuffer.append(((DelInstrText)o).getValue());
            }
        }
        return stringBuffer.toString();
    }
}
