/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.INodeAccessor;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class TextSpan implements IElementWriter, INodeAccessor, Cloneable {

	private DLList<Object> content;

	// attributes
	private String classNames;
	private String styleName;
	private Hyperlink hyperlink;

	public TextSpan() {
		this.classNames = null;
		this.styleName = null;
		this.hyperlink = null;
	}

	public TextSpan(Attributes attributes, Hyperlink hyperlink, String styleName) {
		if(attributes!=null) {
			classNames = attributes.getValue("text:class-names");
		}
		else {
			classNames = null;
		}
		this.styleName = styleName;
		this.hyperlink = hyperlink!=null ? hyperlink.clone() : null;
	}

	@Override
	public DLList<Object> getContent() {
        if (content == null) {
            content = new DLList<Object>();
        }
		return content;
	}

	public void setContent(DLList<Object> content) {
		this.content = content;
	}

	public String getStyleName() {
		if(styleName==null&&hyperlink!=null) {
			return hyperlink.getStyleName();
		}
		return styleName;
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	public Hyperlink getHyperlink(String nmsp, boolean forceCreate) {
		if(hyperlink==null&&forceCreate) {
			hyperlink = new Hyperlink(nmsp);
			hyperlink.setStyleName(styleName);
		}
		return hyperlink;
	}

	public void setHyperlink(Hyperlink hyperlink) {
		this.hyperlink = hyperlink;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(!getContent().isEmpty()) {
			if(hyperlink!=null) {
				hyperlink.writeStartElement(output);
				hyperlink.writeAttributes(output);
				if(styleName!=hyperlink.getStyleName()||classNames!=null) {
					writeSpan(output);
				}
				else {
					writeChilds(output);
				}
				hyperlink.writeEndElement(output);
			}
			else {
				writeSpan(output);
			}
		}
	}

	private void writeSpan(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, Namespaces.TEXT, "span", "text:span");
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "class-names", "text:class-names", classNames);
		SaxContextHandler.addAttribute(output, Namespaces.TEXT, "style-name", "text:style-name", styleName);
		writeChilds(output);
		SaxContextHandler.endElement(output, Namespaces.TEXT, "span", "text:span");
	}

	private void writeChilds(SerializationHandler output)
		throws SAXException {

		for(Object child:getContent()) {
			if(child instanceof IElementWriter) {
				((IElementWriter)child).writeObject(output);
			}
		}
	}

	@Override
    public TextSpan clone() {
		final TextSpan textSpan = new TextSpan();
		textSpan.classNames = classNames;
		textSpan.styleName = styleName;
		textSpan.hyperlink = hyperlink != null ? hyperlink.clone() : null;
		return textSpan;
	}
}
