/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import java.util.TreeSet;
import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class RowHandler extends SaxContextHandler {

    final Sheet sheet;
    final Row row;

    public RowHandler(SheetHandler sheetHandler, Attributes attributes, Row r) {
        super(sheetHandler);
        sheet = sheetHandler.getSheet();
        row = r;

        for(int i=0; i<attributes.getLength(); i++) {
            final String localName = attributes.getLocalName(i);
            if(localName.equals("number-rows-repeated")) {
                row.setRepeated(Integer.valueOf(attributes.getValue(i)));
            }
            else if(localName.equals("default-cell-style-name")) {
                row.setDefaultCellStyle(attributes.getValue(i));
            }
            else if(localName.equals("visibility")) {
                row.setVisibility(Visibility.enumValueOf(attributes.getValue(i)));
            }
            else if(localName.equals("id")) {
                row.setId(attributes.getValue(i));
            }
        }

        // split first row from the row range, if it starts a new row group ("collapse" must be located on the leading row only)
        if ((row.getRepeated() > 1) && (row.getGroupCollapse() != null)) {
            Row startRow = row.splitBefore(row.getRow() + 1);
            sheet.getRows().add(startRow);
            row.setGroupCollapse(null);
        }
    }

    public Sheet getSheet() {
        return sheet;
    }

    public Row getRow() {
        return row;
    }

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
        OdfOperationDoc.abortOnLowMemory(getFileDom());
        if(localName.equals("table-cell")||localName.equals("covered-table-cell")) {
            final TreeSet<Cell> cells = row.getCells();
            int currentColumn = 0;
            if(!cells.isEmpty()) {
                final Cell lastCell = cells.last();
                currentColumn = lastCell.getColumn() + lastCell.getRepeated();
            }
            final Cell newCell = new Cell(currentColumn);
            cells.add(newCell);
            return new CellHandler(this, attributes, sheet, row, newCell);
        }
        return this;
    }
}
