/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONObject;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.styles.StyleManager;

final public class TabStops extends StylePropertiesBase {

	List<TabStop> tabStopList = new ArrayList<TabStop>();

	public TabStops(AttributesImpl attributesImpl) {
		super(attributesImpl);
	}

	public List<TabStop> getTabStopList() {
		return tabStopList;
	}

	public void setTabStopList(List<TabStop> tabStopList) {
		this.tabStopList = tabStopList;
	}

	@Override
	public String getQName() {
		return "style:tab-stops";
	}

	@Override
	public String getLocalName() {
		return "tab-stops";
	}

	@Override
	public String getNamespace() {
		return Namespaces.STYLE;
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		//
	}

	@Override
	public void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(!isEmpty()) {
			SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
			attributes.write(output);
			if(!text.isEmpty()) {
				output.characters(text);
			}
			for(TabStop tabStop:tabStopList) {
				tabStop.writeObject(output);
			}
			final DLList<IElementWriter> content = getContent();
			if(content!=null) {
				final Iterator<IElementWriter> childIter = content.iterator();
				while(childIter.hasNext()) {
					childIter.next().writeObject(output);
				}
			}
			SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
		}
	}

	public boolean isEmpty() {
		return attributes.isEmpty()&&(tabStopList==null||tabStopList.isEmpty())&&(getContent()==null||getContent().isEmpty())&&getTextContent().isEmpty();
	}

	@Override
	public int hashCode() {
		int hash = super.hashCode();
		hash = hash * 31 + attributes.hashCode();
		for(TabStop tabStop:tabStopList) {
			hash = hash * 31 + tabStop.hashCode();
		}
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if(!super.equals(obj)) {
			return false;
		}
		final List<TabStop> other = ((TabStops)obj).getTabStopList();
		if(tabStopList.size()!=other.size()) {
			return false;
		}
		for(int i=0; i<tabStopList.size(); i++) {
			if(!tabStopList.get(i).equals(other.get(i))) {
				return false;
			}
		}
		return true;
	}

	@Override
	public TabStops clone() {
		final TabStops clone = (TabStops)_clone();
		clone.setTabStopList(new ArrayList<TabStop>());
		for(TabStop tabStop:tabStopList) {
			clone.getTabStopList().add(tabStop.clone());
		}
		return clone;
	}
}
