/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.odftoolkit.odfdom.doc.OdfChartDocument;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.xml.sax.Attributes;
import com.openexchange.office.filter.api.DocumentProperties;
import com.openexchange.office.filter.core.PresentationObjectTitles;
import com.openexchange.office.filter.odf.ElementNSWriter;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.UnknownContentHandler;
import com.openexchange.office.filter.odf.table.Table;
import com.openexchange.office.filter.odf.table.TableHandler;
import com.openexchange.office.filter.odp.dom.PresentationStyles;
import com.openexchange.office.filter.ods.dom.chart.ChartContent;
import com.openexchange.office.filter.odt.dom.Paragraph;
import com.openexchange.office.filter.odt.dom.Text;
import com.openexchange.office.filter.odt.dom.TextList;
import com.openexchange.office.filter.odt.dom.TextListItem;
import com.openexchange.office.filter.odt.dom.TextSpan;

public class DrawFrameHandler extends SaxContextHandler {

	final DrawFrame drawFrame;
	private boolean multiImages = false;

	public DrawFrameHandler(SaxContextHandler parentContext, DrawFrame drawFrame) {
    	super(parentContext);

    	this.drawFrame = drawFrame;
	}

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
    	if(qName.equals("draw:image")) {
    		final DrawImage drawImage = new DrawImage(drawFrame, attributes);
    		drawFrame.addContent(drawImage);
    		if(multiImages) {
    		    drawFrame.setMultiImages(true);
    		}
    		multiImages = true;
    		return new DrawImageHandler(this, drawImage);
    	}
    	else if(qName.equals("draw:object")) {
    	    final DrawObject drawObject = new DrawObject(drawFrame, attributes);
    	    drawFrame.addContent(drawObject);
            String documentPath = attributes.getValue("xlink:href");
            if (StringUtils.isNotEmpty(documentPath)) {
                String media = getFileDom().getDocument().getPackage().getMediaTypeString(documentPath);
                if ("application/vnd.oasis.opendocument.chart".equals(media)) {
                    try {
                        final OdfChartDocument subDoc = (OdfChartDocument) getFileDom().getDocument().loadSubDocument(documentPath);
                        subDoc.getStylesDom();
                        final ChartContent chart = (ChartContent) subDoc.getContentDom();
                        drawObject.setChart(chart);
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new DrawObjectHandler(this, drawObject);
        }
    	else if(qName.equals("draw:text-box")) {
    		final DrawTextBox drawTextBox = new DrawTextBox(drawFrame, attributes);
    		drawFrame.addContent(drawTextBox);
    		// replacing presentation placeholder on master page with translated text content
    		if(drawFrame.getAttributes().getBooleanValue("presentation:placeholder", false) && getFileDom() instanceof PresentationStyles) {
    		    final String presentationClass = drawFrame.getAttributes().getValue("presentation:class");
    		    if("title".equals(presentationClass)||"outline".equals(presentationClass)) {
    		        drawTextBox.disableSaveContent();
                    final Map<String, Object> configuration = getFileDom().getDocument().getPackage().getRunTimeConfiguration();
                    final Object o = configuration.get(DocumentProperties.PROP_USER_LANGUAGE);
                    final String userLanguage = o instanceof String ? (String)o : "en";
    		        if("title".equals(presentationClass)) {
    		            final Paragraph paragraph = new Paragraph(null);
    		            drawTextBox.getContent().add(paragraph);
    		            final TextSpan textSpan = new TextSpan();
    		            paragraph.getContent().add(textSpan);
    		            textSpan.getContent().add(new Text(PresentationObjectTitles.getTranslation("title", userLanguage, "Title")));
    		        }
    		        else {
    		            for(int i=1; i<=5; i++) {
                            final Paragraph paragraph = new Paragraph(new TextListItem(new TextList(getFileDom().getDocument().getStyleManager(), null)));
                            paragraph.setListLevel(getFileDom().getDocument().getStyleManager(), i-1);
                            drawTextBox.getContent().add(paragraph);
                            final TextSpan textSpan = new TextSpan();
                            paragraph.getContent().add(textSpan);
                            textSpan.getContent().add(new Text(PresentationObjectTitles.getTranslation("level" + Integer.valueOf(i).toString(), userLanguage, "")));
    		            }
    		        }
    		        // dummy content handler
                    return new UnknownContentHandler(this, new ElementNSWriter(getFileDom(), attributes, uri, qName));
    		    }
    		}
    		return new DrawTextBoxHandler(this, drawTextBox);
    	}
    	else if(qName.equals("table:table")) {
    	    final Table table = new Table(((OdfDocument)getFileDom().getDocument()).getDocumentType(), attributes);
    	    drawFrame.addContent(table);
    	    return new TableHandler(this, table);
    	}
    	final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
    	drawFrame.addContent(element);
		return new UnknownContentHandler(this, element);
    }
}
