/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.odf;

import java.io.InputStream;
import java.util.Map;
import org.json.JSONObject;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import com.openexchange.office.filter.api.DocumentProperties;
import com.openexchange.office.filter.api.IImporter;
import com.openexchange.office.filter.api.IPartImporter;
import com.openexchange.session.Session;

/**
 * {@link Importer}
 *
 * @author <a href="mailto:svante.schubert@open-xchange.com">Svante Schubert</a>
 */
abstract public class Importer implements IImporter, IPartImporter {

    //final ServiceLookup services;

    /**
     * Initializes a new {@link Importer}.
     */
    public Importer() {
        //
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IImporter#createOperations(java.io.InputStream)
     */
    @Override
    public JSONObject createOperations(Session session, InputStream inputDocumentStm, DocumentProperties documentProperties) {

        JSONObject operations = null;
        try (OdfOperationDoc odfdomDocument = new OdfOperationDoc(session, null, documentProperties)) {
            odfdomDocument.loadDocument(inputDocumentStm);
            operations = odfdomDocument.getOperations();
        }
        catch(Throwable e) {
            OdfOperationDoc.rethrowFilterException(e, (OdfPackage)null);
        }
        return operations;
    }

	@Override
	public void initPartitioning(Session session, InputStream inputDocument, DocumentProperties documentProperties) {

	    try(OdfOperationDoc odfdomDocument = new OdfOperationDoc(session, null, documentProperties)) {
            odfdomDocument.loadDocument(inputDocument);
            documentProperties.put(DocumentProperties.PROP_DOCUMENT, odfdomDocument);
    		odfdomDocument.initPartitioning(documentProperties);
	    }
	    catch(Throwable e) {
            OdfOperationDoc.rethrowFilterException(e, (OdfPackage)null);
	    }
	}

	@Override
	public Map<String, Object> getMetaData(DocumentProperties documentProperties) {
        Map<String, Object> metaData = null;
	    final OdfOperationDoc operationDocument = (OdfOperationDoc)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
	    try {
	        operationDocument.registerMemoryListener();
	        metaData = operationDocument.getMetaData(documentProperties);
	    }
	    catch(Throwable e) {
	        OdfOperationDoc.rethrowFilterException(e, operationDocument);
	    }
	    finally {
	        operationDocument.close();
	    }
	    return metaData;
	}

	@Override
	public Map<String, Object> getActivePart(DocumentProperties documentProperties) {
        Map<String, Object> metaData = null;
	    final OdfOperationDoc operationDocument = (OdfOperationDoc)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
	    try {
            operationDocument.registerMemoryListener();
	        metaData = operationDocument.getActivePart(documentProperties);
	    }
        catch(Throwable e) {
            OdfOperationDoc.rethrowFilterException(e, operationDocument);
        }
        finally {
            operationDocument.close();
        }
        return metaData;
	}

	@Override
	public Map<String, Object> getNextPart(DocumentProperties documentProperties) {
        Map<String, Object> metaData = null;
	    final OdfOperationDoc operationDocument = (OdfOperationDoc)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
	    try {
            operationDocument.registerMemoryListener();
	        metaData = operationDocument.getNextPart(documentProperties);
	    }
        catch(Throwable e) {
            OdfOperationDoc.rethrowFilterException(e, operationDocument);
        }
        finally {
            operationDocument.close();
        }
        return metaData;
	}
}
