/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j.dml.wordprocessingDrawing;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualGraphicFrameProperties;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.INonVisualDrawingPropertyAccess;
import org.docx4j.dml.INonVisualDrawingShapePropertyAccess;
import com.openexchange.office.filter.core.component.Child;

@XmlTransient
public abstract class GraphicBase implements INonVisualDrawingPropertyAccess, INonVisualDrawingShapePropertyAccess, Child {

    @XmlElement(required = true)
    protected CTPositiveSize2D extent;
    protected CTEffectExtent effectExtent;
    @XmlElement(required = true)
    protected CTNonVisualDrawingProps docPr;
    protected CTNonVisualGraphicFrameProperties cNvGraphicFramePr;
    @XmlElement(namespace = "http://schemas.openxmlformats.org/drawingml/2006/main", required = true)
    protected Graphic graphic;
    @XmlAttribute
    protected Long distT;
    @XmlAttribute
    protected Long distB;
    @XmlAttribute
    protected Long distL;
    @XmlAttribute
    protected Long distR;
    @XmlTransient
    private Object parent;

    /**
     * Gets the value of the extent property.
     *
     * @return
     *     possible object is
     *     {@link CTPositiveSize2D }
     *
     */
    public CTPositiveSize2D getExtent() {
        return extent;
    }

    /**
     * Sets the value of the extent property.
     *
     * @param value
     *     allowed object is
     *     {@link CTPositiveSize2D }
     *
     */
    public void setExtent(CTPositiveSize2D value) {
        this.extent = value;
    }

    /**
     * Gets the value of the effectExtent property.
     *
     * @return
     *     possible object is
     *     {@link CTEffectExtent }
     *
     */
    public CTEffectExtent getEffectExtent() {
        return effectExtent;
    }

    /**
     * Sets the value of the effectExtent property.
     *
     * @param value
     *     allowed object is
     *     {@link CTEffectExtent }
     *
     */
    public void setEffectExtent(CTEffectExtent value) {
        this.effectExtent = value;
    }

    /**
     * Gets the value of the docPr property.
     *
     * @return
     *     possible object is
     *     {@link CTNonVisualDrawingProps }
     *
     */
    public CTNonVisualDrawingProps getNonVisualDrawingProperties(boolean createIfMissing) {
    	if(docPr==null&&createIfMissing) {
    		docPr = new CTNonVisualDrawingProps();
    	}
    	return docPr;
    }

    public void setNonVisualDrawingProperties(CTNonVisualDrawingProps props) {
    	docPr = props;
    }

    /**
     * Gets the value of the cNvGraphicFramePr property.
     *
     * @return
     *     possible object is
     *     {@link CTNonVisualGraphicFrameProperties }
     *
     */
    public CTNonVisualGraphicFrameProperties getNonVisualDrawingShapeProperties(boolean createIfMissing) {
    	if(cNvGraphicFramePr==null&&createIfMissing) {
    		cNvGraphicFramePr = new CTNonVisualGraphicFrameProperties();
    	}
    	return cNvGraphicFramePr;
    }

    public void setNonVisualDrawingShapeProperties(CTNonVisualGraphicFrameProperties props) {
    	cNvGraphicFramePr = props;
    }

    /**
     * Gets the value of the graphic property.
     *
     * @return
     *     possible object is
     *     {@link Graphic }
     *
     */
    public Graphic getGraphic() {
        return graphic;
    }

    /**
     * Sets the value of the graphic property.
     *
     * @param value
     *     allowed object is
     *     {@link Graphic }
     *
     */
    public void setGraphic(Graphic value) {
        this.graphic = value;
    }

    /**
     * Gets the value of the distT property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public Long getDistT() {
        return distT;
    }

    /**
     * Sets the value of the distT property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setDistT(Long value) {
        this.distT = value;
    }

    /**
     * Gets the value of the distB property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public Long getDistB() {
        return distB;
    }

    /**
     * Sets the value of the distB property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setDistB(Long value) {
        this.distB = value;
    }

    /**
     * Gets the value of the distL property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public Long getDistL() {
        return distL;
    }

    /**
     * Sets the value of the distL property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setDistL(Long value) {
        this.distL = value;
    }

    /**
     * Gets the value of the distR property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public Long getDistR() {
        return distR;
    }

    /**
     * Sets the value of the distR property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setDistR(Long value) {
        this.distR = value;
    }

    /**
     * Gets the parent object in the object tree representing the unmarshalled xml document.
     *
     * @return
     *     The parent object.
     */
    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }
}
