/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.ContentType;
import net.jcip.annotations.Immutable;

@Immutable
public final class ClientSecretPost
extends PlainClientSecret {
    public ClientSecretPost(ClientID clientID, Secret secret) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_POST, clientID, secret);
    }

    public Map<String, String> toParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.getClientID().getValue());
        params.put("client_secret", this.getClientSecret().getValue());
        return params;
    }

    @Override
    public void applyTo(HTTPRequest httpRequest) {
        if (httpRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        ContentType ct = httpRequest.getContentType();
        if (ct == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!ct.match(CommonContentTypes.APPLICATION_URLENCODED)) {
            throw new SerializeException("The HTTP Content-Type header must be " + CommonContentTypes.APPLICATION_URLENCODED);
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        params.putAll(this.toParameters());
        String queryString = URLUtils.serializeParameters(params);
        httpRequest.setQuery(queryString);
    }

    public static ClientSecretPost parse(Map<String, String> params) throws ParseException {
        String clientIDString = params.get("client_id");
        if (clientIDString == null) {
            throw new ParseException("Malformed client secret post authentication: Missing \"client_id\" parameter");
        }
        String secretValue = params.get("client_secret");
        if (secretValue == null) {
            throw new ParseException("Malformed client secret post authentication: Missing \"client_secret\" parameter");
        }
        return new ClientSecretPost(new ClientID(clientIDString), new Secret(secretValue));
    }

    public static ClientSecretPost parse(String paramsString) throws ParseException {
        Map<String, String> params = URLUtils.parseParameters(paramsString);
        return ClientSecretPost.parse(params);
    }

    public static ClientSecretPost parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        return ClientSecretPost.parse(httpRequest.getQueryParameters());
    }

    public static /* bridge */ /* synthetic */ ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return ClientSecretPost.parse(hTTPRequest);
    }
}

