/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.gdata.client.Query;
import java.net.URL;
import java.util.List;

public class GoogleBaseQuery
extends Query {
    private static final String BQ_PARAMETER = "bq";
    private static final String MAX_VALUES_PARAMETER = "max-values";
    private static final String ORDER_BY = "orderby";
    private static final String CROWD_BY = "crowdby";
    private static final String SORT_ORDER = "sortorder";
    private static final String CONTENT = "content";
    private static final String REFINE = "refine";

    public GoogleBaseQuery(URL feedUrl) {
        super(feedUrl);
    }

    public void setGoogleBaseQuery(String query) {
        this.overwriteCustomParameter(BQ_PARAMETER, query);
    }

    public String getGoogleBaseQuery() {
        String parameterName = BQ_PARAMETER;
        return this.getCustomParameterValue(parameterName);
    }

    private String getCustomParameterValue(String parameterName) {
        List customParams = this.getCustomParameters(parameterName);
        if (customParams.isEmpty()) {
            return null;
        }
        return ((Query.CustomParameter)customParams.get(0)).getValue();
    }

    private void overwriteCustomParameter(String name, String value) {
        List customParams = this.getCustomParameters();
        for (Query.CustomParameter existingValue : this.getCustomParameters(name)) {
            customParams.remove(existingValue);
        }
        if (value != null) {
            customParams.add(new Query.CustomParameter(name, value));
        }
    }

    public void setMaxValues(Integer maxValues) {
        String stringValue = maxValues == null ? null : maxValues.toString();
        this.overwriteCustomParameter(MAX_VALUES_PARAMETER, stringValue);
    }

    public Integer getMaxValues() {
        String valueAsString = this.getCustomParameterValue(MAX_VALUES_PARAMETER);
        if (valueAsString == null) {
            return null;
        }
        return new Integer(valueAsString);
    }

    public void setRefine(boolean refine) {
        this.overwriteCustomParameter(REFINE, refine ? "true" : "false");
    }

    public boolean getRefine() {
        return "true".equals(this.getCustomParameterValue(REFINE));
    }

    public void setContent(String content) {
        this.overwriteCustomParameter(CONTENT, content);
    }

    public String getContent() {
        return this.getCustomParameterValue(CONTENT);
    }

    public void setOrderBy(String orderBy) {
        this.overwriteCustomParameter(ORDER_BY, orderBy);
    }

    public void setCrowdingBy(String crowdBy) {
        this.overwriteCustomParameter(CROWD_BY, crowdBy);
    }

    public String getOrderBy() {
        return this.getCustomParameterValue(ORDER_BY);
    }

    public String getCrowdBy() {
        return this.getCustomParameterValue(CROWD_BY);
    }

    public void setAscendingOrder(boolean ascending) {
        this.overwriteCustomParameter(SORT_ORDER, ascending ? "ascending" : "descending");
    }

    public boolean isAscendingOrder() {
        return "ascending".equals(this.getCustomParameterValue(SORT_ORDER));
    }
}

