/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.yubico.u2f.data.messages.ClientData;
import com.yubico.u2f.data.messages.json.JsonSerializable;
import com.yubico.u2f.data.messages.json.Persistable;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SignResponse
extends JsonSerializable
implements Persistable {
    private static final int MAX_SIZE = 20000;
    @JsonProperty(value="clientData")
    private final String clientDataRaw;
    @JsonIgnore
    private transient ClientData clientDataRef;
    @JsonProperty
    private final String signatureData;
    @JsonProperty
    private final String keyHandle;

    @JsonCreator
    public SignResponse(@JsonProperty(value="clientData") String clientData, @JsonProperty(value="signatureData") String signatureData, @JsonProperty(value="keyHandle") String keyHandle) throws U2fBadInputException {
        this.clientDataRaw = (String)Preconditions.checkNotNull((Object)clientData);
        this.signatureData = (String)Preconditions.checkNotNull((Object)signatureData);
        this.keyHandle = (String)Preconditions.checkNotNull((Object)keyHandle);
        this.clientDataRef = new ClientData(clientData);
    }

    @JsonIgnore
    public ClientData getClientData() {
        return this.clientDataRef;
    }

    public String getSignatureData() {
        return this.signatureData;
    }

    public String getKeyHandle() {
        return this.keyHandle;
    }

    @Override
    public String getRequestId() {
        return this.getClientData().getChallenge();
    }

    public static SignResponse fromJson(String json) throws U2fBadInputException {
        Preconditions.checkArgument((json.length() < 20000 ? 1 : 0) != 0, (Object)"Client response bigger than allowed");
        return SignResponse.fromJson(json, SignResponse.class);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.clientDataRef = new ClientData(this.clientDataRaw);
        }
        catch (U2fBadInputException e) {
            throw new IOException(e);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignResponse)) {
            return false;
        }
        SignResponse other = (SignResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientDataRaw = this.clientDataRaw;
        String other$clientDataRaw = other.clientDataRaw;
        if (this$clientDataRaw == null ? other$clientDataRaw != null : !this$clientDataRaw.equals(other$clientDataRaw)) {
            return false;
        }
        String this$signatureData = this.getSignatureData();
        String other$signatureData = other.getSignatureData();
        if (this$signatureData == null ? other$signatureData != null : !this$signatureData.equals(other$signatureData)) {
            return false;
        }
        String this$keyHandle = this.getKeyHandle();
        String other$keyHandle = other.getKeyHandle();
        return !(this$keyHandle == null ? other$keyHandle != null : !this$keyHandle.equals(other$keyHandle));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientDataRaw = this.clientDataRaw;
        result = result * 59 + ($clientDataRaw == null ? 43 : $clientDataRaw.hashCode());
        String $signatureData = this.getSignatureData();
        result = result * 59 + ($signatureData == null ? 43 : $signatureData.hashCode());
        String $keyHandle = this.getKeyHandle();
        result = result * 59 + ($keyHandle == null ? 43 : $keyHandle.hashCode());
        return result;
    }
}

