/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.docu.parser;

import com.openexchange.config.docu.parser.DocumentationGenerator;
import com.openexchange.config.docu.parser.JSONPrepared;
import com.openexchange.config.docu.parser.Property;
import com.openexchange.config.docu.parser.YamlFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JSONGenerator
implements DocumentationGenerator<JSONPrepared> {
    private static Map<String, String> sanitizing = new HashMap<String, String>(2);

    @Override
    public JSONPrepared prepareOutputData(List<YamlFile> yamlFiles, String version, String chosenPackage) {
        JSONArray properties = new JSONArray();
        ArrayList<JSONObject> featuresList = new ArrayList<JSONObject>();
        TreeSet<String> tagsSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (YamlFile ymlFile : yamlFiles) {
            for (Property prop : ymlFile.getProperties()) {
                if (JSONGenerator.isNullOrEmpty(chosenPackage)) {
                    this.JSONObjecttoJSONObject(prop, version, ymlFile, properties, tagsSet);
                    continue;
                }
                if (prop.getPackageName() == null || !prop.getPackageName().equals(chosenPackage)) continue;
                this.JSONObjecttoJSONObject(prop, version, ymlFile, properties, tagsSet);
            }
            JSONObject feature = new JSONObject();
            feature.put((Object)"Name", (Object)ymlFile.getFeature_name());
            feature.put((Object)"Description", (Object)JSONGenerator.transformSquareBracketsToATags(JSONGenerator.replaceVersionKeyWords(JSONGenerator.replaceLineBreak(ymlFile.getFeature_description()), version)));
            featuresList.add(feature);
        }
        JSONPrepared p = new JSONPrepared(properties, featuresList, tagsSet, version);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONPrepared prepared, File destination) throws IOException {
        File file = new File(destination, "properties.json");
        FileWriter writer = new FileWriter(file);
        try {
            JSONObject json = new JSONObject();
            json.put((Object)"properties", (Object)prepared.getProperties());
            Collections.sort(prepared.getFeaturesList(), new Comparator<JSONObject>(){

                @Override
                public int compare(JSONObject o1, JSONObject o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    return o1.get((Object)"Name").toString().compareTo(o2.get((Object)"Name").toString());
                }
            });
            JSONArray features = new JSONArray();
            features.addAll(prepared.getFeaturesList());
            json.put((Object)"features", (Object)features);
            JSONArray tags = new JSONArray();
            tags.addAll(prepared.getTagsSet());
            json.put((Object)"tags", (Object)tags);
            JSONObject versionJSON = new JSONObject();
            versionJSON.put((Object)"Year", (Object)Calendar.getInstance().get(1));
            versionJSON.put((Object)"Version", (Object)prepared.getVersion());
            json.put((Object)"version", (Object)versionJSON);
            writer.write(json.toJSONString());
        }
        finally {
            writer.close();
        }
    }

    public void JSONObjecttoJSONObject(Property prop, String version, YamlFile ymlFile, JSONArray properties, SortedSet<String> tagsSet) {
        JSONObject property = new JSONObject();
        property.put((Object)"Key", (Object)prop.getKey());
        property.put((Object)"Default", JSONGenerator.sanitize(prop.getDefaultValue()));
        property.put((Object)"File", (Object)JSONGenerator.replaceLineBreak(prop.getFile()));
        property.put((Object)"Package", (Object)prop.getPackageName());
        property.put((Object)"Description", (Object)JSONGenerator.transformSquareBracketsToATags(JSONGenerator.replaceVersionKeyWords(JSONGenerator.replaceLineBreak(prop.getDescription()), version)));
        property.put((Object)"ConfigCascadeAware", (Object)prop.isConfigcascadeAware());
        property.put((Object)"Reloadable", (Object)prop.isReloadable());
        JSONGenerator.parseRelated(property, prop);
        property.put((Object)"Version", (Object)prop.getVersion());
        property.put((Object)"Tags", prop.getTags());
        property.put((Object)"Feature", (Object)ymlFile.getFeature_name());
        properties.add((Object)property);
        if (prop.getTags() != null) {
            tagsSet.addAll(prop.getTags());
        }
    }

    private static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().length() == 0;
    }

    private static String replaceVersionKeyWords(String value, String version) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("\\{\\{version\\}\\}", version);
    }

    private static String transformSquareBracketsToATags(String value) {
        if (value == null) {
            return value;
        }
        int indexLeft = value.indexOf("[[");
        int indexRight = value.indexOf("]]");
        while (indexLeft >= 0 && indexRight > indexLeft) {
            String property = value.substring(indexLeft + 2, indexRight);
            value = property.toLowerCase().startsWith("http://") || property.toLowerCase().startsWith("https://") ? value.replaceFirst("\\[\\[", "<a href=" + property + ">") : value.replaceFirst("\\[\\[", "<a href=#" + property + ">");
            value = value.replaceFirst("\\]\\]", "</a>");
            indexLeft = value.indexOf("[[");
            indexRight = value.indexOf("]]");
        }
        return value;
    }

    private static void parseRelated(JSONObject jsonProperty, Property property) {
        Object relatedObject = property.getRelated();
        if (relatedObject == null) {
            return;
        }
        if (relatedObject instanceof String) {
            ArrayList<String> relatedStrings = new ArrayList<String>(1);
            String relatedStr = (String)relatedObject;
            relatedStr = JSONGenerator.createPropertyATag(relatedStr);
            relatedStrings.add(relatedStr);
            jsonProperty.put((Object)"Related", relatedStrings);
        } else {
            List relatedList = (List)relatedObject;
            ArrayList<String> relatedStrings = new ArrayList<String>(relatedList.size());
            for (String relatedItem : relatedList) {
                relatedStrings.add(JSONGenerator.createPropertyATag(relatedItem));
            }
            jsonProperty.put((Object)"Related", relatedStrings);
        }
    }

    private static String createPropertyATag(String propertyName) {
        StringBuilder builder = new StringBuilder();
        builder.append("<a href=\"#");
        builder.append(propertyName);
        builder.append("\">");
        builder.append(propertyName);
        builder.append("</a>");
        return builder.toString();
    }

    private static String replaceLineBreak(String stringWithLineBreak) {
        if (stringWithLineBreak == null) {
            return null;
        }
        String tmp = stringWithLineBreak.replaceAll("  \n", "<br>");
        return tmp.replaceAll("\n\n", "<br><br>");
    }

    private static Object sanitize(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        String result = (String)value;
        for (String key : sanitizing.keySet()) {
            result = result.replaceAll(key, sanitizing.get(key));
        }
        return result;
    }

    static {
        sanitizing.put("<", "&lt;");
        sanitizing.put(">", "&gt;");
    }
}

