/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.build.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0082\u0010J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/openexchange/build/utils/GradleProjectUtil;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "findProjectRecursively", "path", "", "searchProject", "build-utils"})
public final class GradleProjectUtil {
    private final Project project;

    @Nullable
    public final Project searchProject(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        StringBuilder stringBuilder = new StringBuilder().append(":");
        Project project = this.project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.projectDir");
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.rootProject.projectDir.path");
        String modified = stringBuilder.append(StringsKt.removePrefix((String)StringsKt.removePrefix((String)path, (CharSequence)string), (CharSequence)"/")).toString();
        return this.findProjectRecursively(modified);
    }

    private final Project findProjectRecursively(String path) {
        Project project;
        while (true) {
            if (path == null) {
                return null;
            }
            project = this.project.findProject(path);
            if (project != null) break;
            path = StringsKt.substringBeforeLast$default((String)path, (String)"/", null, (int)2, null);
        }
        return project;
    }

    public GradleProjectUtil(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

